/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.lib.paralithic.eval;

import com.dfsek.terra.addons.noise.lib.paralithic.node.Node;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.BinaryNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.booleans.AndNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.booleans.ComparisonNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.booleans.OrNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.number.AdditionNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.number.DivisionNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.number.ModuloNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.number.MultiplicationNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.number.SubtractionNode;
import com.dfsek.terra.addons.noise.lib.paralithic.node.binary.special.PowerNode;

public class ParserUtil {
    public static BinaryNode createBinaryOperation(BinaryNode.Op op, Node left, Node right) {
        switch (op) {
            case ADD: {
                return new AdditionNode(left, right);
            }
            case SUBTRACT: {
                return new SubtractionNode(left, right);
            }
            case MULTIPLY: {
                return new MultiplicationNode(left, right);
            }
            case DIVIDE: {
                return new DivisionNode(left, right);
            }
            case POWER: {
                return new PowerNode(left, right);
            }
            case MODULO: {
                return new ModuloNode(left, right);
            }
            case LT: 
            case LT_EQ: 
            case GT: 
            case GT_EQ: 
            case EQ: 
            case NEQ: {
                return new ComparisonNode(left, right, op);
            }
            case AND: {
                return new AndNode(left, right);
            }
            case OR: {
                return new OrNode(left, right);
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)op));
    }
}

