/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.lib.paralithic.eval.tokenizer;

import com.dfsek.terra.addons.noise.lib.paralithic.eval.tokenizer.Char;
import com.dfsek.terra.addons.noise.lib.paralithic.eval.tokenizer.Position;
import java.util.Objects;
import java.util.stream.Stream;

public class Token
implements Position {
    protected int pos;
    private TokenType type;
    private String trigger = "";
    private String internTrigger = null;
    private String contents = "";
    private String source = "";
    private int line;

    private Token() {
    }

    public static Token create(TokenType type, Position pos) {
        Token result = new Token();
        result.type = type;
        result.line = pos.getLine();
        result.pos = pos.getPos();
        return result;
    }

    public static Token createAndFill(TokenType type, Char ch) {
        Token result = new Token();
        result.type = type;
        result.line = ch.getLine();
        result.pos = ch.getPos();
        result.contents = ch.getStringValue();
        result.trigger = ch.getStringValue();
        result.source = ch.toString();
        return result;
    }

    public Token addToTrigger(Char ch) {
        this.trigger = this.trigger + ch.getValue();
        this.internTrigger = null;
        this.source = this.source + ch.getValue();
        return this;
    }

    public Token addToSource(Char ch) {
        this.source = this.source + ch.getValue();
        return this;
    }

    public Token addToContent(Char ch) {
        return this.addToContent(ch.getValue());
    }

    public Token addToContent(char ch) {
        this.contents = this.contents + ch;
        this.source = this.source + ch;
        return this;
    }

    public Token silentAddToContent(char ch) {
        this.contents = this.contents + ch;
        return this;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    public void setContent(String content) {
        this.contents = content;
    }

    public boolean isEnd() {
        return this.type == TokenType.EOI;
    }

    public boolean isNotEnd() {
        return this.type != TokenType.EOI;
    }

    public boolean wasTriggeredBy(String ... triggers) {
        return Stream.of(triggers).filter(Objects::nonNull).anyMatch(trigger -> Objects.equals(trigger, this.getTrigger()));
    }

    public String getTrigger() {
        if (this.internTrigger == null) {
            this.internTrigger = this.trigger.intern();
        }
        return this.internTrigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
        this.internTrigger = null;
    }

    public boolean hasContent(String content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        return content.equalsIgnoreCase(this.getContents());
    }

    public String getContents() {
        return this.contents;
    }

    public boolean isSymbol(String ... symbols) {
        if (symbols.length == 0) {
            return this.is(TokenType.SYMBOL);
        }
        for (String symbol : symbols) {
            if (!this.matches(TokenType.SYMBOL, symbol)) continue;
            return true;
        }
        return false;
    }

    public boolean is(TokenType type) {
        return this.type == type;
    }

    public boolean matches(TokenType type, String trigger) {
        if (!this.is(type)) {
            return false;
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger must not be null");
        }
        return Objects.equals(this.getTrigger(), trigger.intern());
    }

    public boolean isKeyword(String ... keywords) {
        if (keywords.length == 0) {
            return this.is(TokenType.KEYWORD);
        }
        for (String keyword : keywords) {
            if (!this.matches(TokenType.KEYWORD, keyword)) continue;
            return true;
        }
        return false;
    }

    public boolean isIdentifier(String ... values) {
        if (values.length == 0) {
            return this.is(TokenType.ID);
        }
        for (String value : values) {
            if (!this.matches(TokenType.ID, value)) continue;
            return true;
        }
        return false;
    }

    public boolean isSpecialIdentifier(String ... triggers) {
        if (triggers.length == 0) {
            return this.is(TokenType.SPECIAL_ID);
        }
        for (String possibleTrigger : triggers) {
            if (!this.matches(TokenType.SPECIAL_ID, possibleTrigger)) continue;
            return true;
        }
        return false;
    }

    public boolean isSpecialIdentifierWithContent(String trigger, String ... contents) {
        if (!this.matches(TokenType.SPECIAL_ID, trigger)) {
            return false;
        }
        if (contents.length == 0) {
            return true;
        }
        for (String content : contents) {
            if (content == null || !content.equals(this.getContents())) continue;
            return true;
        }
        return false;
    }

    public boolean isNumber() {
        return this.isInteger() || this.isDecimal() || this.isScientificDecimal();
    }

    public boolean isInteger() {
        return this.is(TokenType.INTEGER);
    }

    public boolean isDecimal() {
        return this.is(TokenType.DECIMAL);
    }

    public boolean isScientificDecimal() {
        return this.is(TokenType.SCIENTIFIC_DECIMAL);
    }

    public boolean isString() {
        return this.is(TokenType.STRING);
    }

    public String toString() {
        return this.getType().toString() + ":" + this.getSource() + " (" + this.line + ":" + this.pos + ")";
    }

    public TokenType getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static enum TokenType {
        ID,
        SPECIAL_ID,
        STRING,
        DECIMAL,
        SCIENTIFIC_DECIMAL,
        INTEGER,
        SYMBOL,
        KEYWORD,
        EOI;

    }
}

