/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.samplers;

import com.dfsek.terra.api.noise.NoiseSampler;

public class KernelSampler
implements NoiseSampler {
    private final double[][] kernel;
    private final NoiseSampler in;
    private double frequency = 1.0;

    public KernelSampler(double[][] kernel, NoiseSampler in) {
        this.kernel = kernel;
        this.in = in;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public double noise(long seed, double x, double y) {
        x *= this.frequency;
        y *= this.frequency;
        double accumulator = 0.0;
        for (int kx = 0; kx < this.kernel.length; ++kx) {
            for (int ky = 0; ky < this.kernel[kx].length; ++ky) {
                double k = this.kernel[kx][ky];
                if (k == 0.0) continue;
                accumulator += this.in.noise(seed, x + (double)kx, y + (double)ky) * k;
            }
        }
        return accumulator;
    }

    public double noise(long seed, double x, double y, double z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        double accumulator = 0.0;
        for (int kx = 0; kx < this.kernel.length; ++kx) {
            for (int ky = 0; ky < this.kernel[kx].length; ++ky) {
                double k = this.kernel[kx][ky];
                if (k == 0.0) continue;
                accumulator += this.in.noise(seed, x + (double)kx, y, z + (double)ky) * k;
            }
        }
        return accumulator;
    }
}

