/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.samplers.noise.fractal;

import com.dfsek.terra.addons.noise.samplers.noise.fractal.FractalNoiseFunction;
import com.dfsek.terra.api.noise.NoiseSampler;

public class RidgedFractalSampler
extends FractalNoiseFunction {
    public RidgedFractalSampler(NoiseSampler input) {
        super(input);
    }

    @Override
    public double getNoiseRaw(long seed, double x, double y) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = RidgedFractalSampler.fastAbs(this.input.noise(seed++, x, y));
            sum += (noise * -2.0 + 1.0) * amp;
            amp *= RidgedFractalSampler.lerp(1.0, 1.0 - noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }

    @Override
    public double getNoiseRaw(long seed, double x, double y, double z) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = RidgedFractalSampler.fastAbs(this.input.noise(seed++, x, y, z));
            sum += (noise * -2.0 + 1.0) * amp;
            amp *= RidgedFractalSampler.lerp(1.0, 1.0 - noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }
}

