/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline;

import com.dfsek.terra.addons.biome.pipeline.api.BiomeHolder;
import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.type.BiomeExpander;
import com.dfsek.terra.addons.biome.pipeline.api.stage.type.BiomeMutator;
import com.dfsek.terra.addons.biome.pipeline.source.BiomeSource;
import com.dfsek.terra.api.util.vector.Vector2;

public class BiomeHolderImpl
implements BiomeHolder {
    private final Vector2.Mutable origin;
    private final int width;
    private final int offset;
    private BiomeDelegate[][] biomes;

    public BiomeHolderImpl(int width, Vector2.Mutable origin) {
        this.width = width += 4;
        this.biomes = new BiomeDelegate[width][width];
        this.origin = origin;
        this.offset = 2;
    }

    private BiomeHolderImpl(BiomeDelegate[][] biomes, Vector2.Mutable origin, int width, int offset) {
        this.biomes = biomes;
        this.origin = origin;
        this.width = width;
        this.offset = 2 * offset;
    }

    @Override
    public BiomeHolder expand(BiomeExpander expander, long seed) {
        BiomeDelegate[][] old = this.biomes;
        int newWidth = this.width * 2 - 1;
        this.biomes = new BiomeDelegate[newWidth][newWidth];
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                this.biomes[x * 2][z * 2] = old[x][z];
                if (z != this.width - 1) {
                    this.biomes[x * 2][z * 2 + 1] = expander.getBetween((double)x + this.origin.getX(), (double)(z + 1) + this.origin.getZ(), seed, old[x][z], old[x][z + 1]);
                }
                if (x != this.width - 1) {
                    this.biomes[x * 2 + 1][z * 2] = expander.getBetween((double)(x + 1) + this.origin.getX(), (double)z + this.origin.getZ(), seed, old[x][z], old[x + 1][z]);
                }
                if (x == this.width - 1 || z == this.width - 1) continue;
                this.biomes[x * 2 + 1][z * 2 + 1] = expander.getBetween((double)(x + 1) + this.origin.getX(), (double)(z + 1) + this.origin.getZ(), seed, old[x][z], old[x + 1][z + 1], old[x][z + 1], old[x + 1][z]);
            }
        }
        return new BiomeHolderImpl(this.biomes, this.origin.setX(this.origin.getX() * 2.0 - 1.0).setZ(this.origin.getZ() * 2.0 - 1.0), newWidth, this.offset);
    }

    @Override
    public void mutate(BiomeMutator mutator, long seed) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                BiomeMutator.ViewPoint viewPoint = new BiomeMutator.ViewPoint(this, x, z);
                this.biomes[x][z] = mutator.mutate(viewPoint, (double)x + this.origin.getX(), (double)z + this.origin.getZ(), seed);
            }
        }
    }

    @Override
    public void fill(BiomeSource source, long seed) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                this.biomes[x][z] = source.getBiome(this.origin.getX() + (double)x, this.origin.getZ() + (double)z, seed);
            }
        }
    }

    @Override
    public BiomeDelegate getBiome(int x, int z) {
        return this.getBiomeRaw(x += this.offset, z += this.offset);
    }

    @Override
    public BiomeDelegate getBiomeRaw(int x, int z) {
        if (x >= this.width || z >= this.width || x < 0 || z < 0) {
            return null;
        }
        return this.biomes[x][z];
    }
}

