/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.mutator;

import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.type.BiomeMutator;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;

public class BorderListMutator
implements BiomeMutator {
    private final String border;
    private final NoiseSampler noiseSampler;
    private final ProbabilityCollection<BiomeDelegate> replaceDefault;
    private final String defaultReplace;
    private final Map<BiomeDelegate, ProbabilityCollection<BiomeDelegate>> replace;

    public BorderListMutator(Map<BiomeDelegate, ProbabilityCollection<BiomeDelegate>> replace, String border, String defaultReplace, NoiseSampler noiseSampler, ProbabilityCollection<BiomeDelegate> replaceDefault) {
        this.border = border;
        this.noiseSampler = noiseSampler;
        this.replaceDefault = replaceDefault;
        this.defaultReplace = defaultReplace;
        this.replace = replace;
    }

    @Override
    public BiomeDelegate mutate(BiomeMutator.ViewPoint viewPoint, double x, double z, long seed) {
        BiomeDelegate origin = viewPoint.getBiome(0, 0);
        if (origin.getTags().contains(this.defaultReplace)) {
            for (int xi = -1; xi <= 1; ++xi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    BiomeDelegate current;
                    if (xi == 0 && zi == 0 || (current = viewPoint.getBiome(xi, zi)) == null || !current.getTags().contains(this.border)) continue;
                    if (this.replace.containsKey(origin)) {
                        BiomeDelegate biome = (BiomeDelegate)this.replace.get(origin).get(this.noiseSampler, x, z, seed);
                        return biome.isSelf() ? origin : biome;
                    }
                    BiomeDelegate biome = (BiomeDelegate)this.replaceDefault.get(this.noiseSampler, x, z, seed);
                    return biome.isSelf() ? origin : biome;
                }
            }
        }
        return origin;
    }

    @Override
    public Iterable<BiomeDelegate> getBiomes(Iterable<BiomeDelegate> biomes) {
        HashSet<BiomeDelegate> biomeSet = new HashSet<BiomeDelegate>();
        biomes.forEach(biomeSet::add);
        biomeSet.addAll(this.replaceDefault.getContents().stream().filter(Predicate.not(BiomeDelegate::isSelf)).toList());
        this.replace.forEach((biome, collection) -> biomeSet.addAll(collection.getContents()));
        return biomeSet;
    }
}

