/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.mutator;

import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.type.BiomeMutator;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;

public class ReplaceListMutator
implements BiomeMutator {
    private final Map<BiomeDelegate, ProbabilityCollection<BiomeDelegate>> replace;
    private final NoiseSampler sampler;
    private final ProbabilityCollection<BiomeDelegate> replaceDefault;
    private final String defaultTag;

    public ReplaceListMutator(Map<BiomeDelegate, ProbabilityCollection<BiomeDelegate>> replace, String defaultTag, ProbabilityCollection<BiomeDelegate> replaceDefault, NoiseSampler sampler) {
        this.replace = replace;
        this.sampler = sampler;
        this.defaultTag = defaultTag;
        this.replaceDefault = replaceDefault;
    }

    @Override
    public BiomeDelegate mutate(BiomeMutator.ViewPoint viewPoint, double x, double z, long seed) {
        BiomeDelegate center = viewPoint.getBiome(0, 0);
        if (this.replace.containsKey(center)) {
            BiomeDelegate biome = (BiomeDelegate)this.replace.get(center).get(this.sampler, x, z, seed);
            return biome.isSelf() ? viewPoint.getBiome(0, 0) : biome;
        }
        if (viewPoint.getBiome(0, 0).getTags().contains(this.defaultTag)) {
            BiomeDelegate biome = (BiomeDelegate)this.replaceDefault.get(this.sampler, x, z, seed);
            return biome.isSelf() ? viewPoint.getBiome(0, 0) : biome;
        }
        return center;
    }

    @Override
    public Iterable<BiomeDelegate> getBiomes(Iterable<BiomeDelegate> biomes) {
        HashSet<BiomeDelegate> biomeSet = new HashSet<BiomeDelegate>();
        HashSet reject = new HashSet();
        biomes.forEach(biome -> {
            if (!biome.getTags().contains(this.defaultTag) && !this.replace.containsKey(biome)) {
                biomeSet.add((BiomeDelegate)biome);
            } else {
                reject.add(biome);
            }
        });
        biomeSet.addAll(this.replaceDefault.getContents().stream().flatMap(terraBiome -> {
            if (terraBiome.isSelf()) {
                return reject.stream();
            }
            return Stream.of(terraBiome);
        }).toList());
        this.replace.forEach((biome, collection) -> biomeSet.addAll(collection.getContents().stream().map(terraBiome -> {
            if (terraBiome.isSelf()) {
                return biome;
            }
            return terraBiome;
        }).toList()));
        return biomeSet;
    }
}

