/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.caffeine.cache;

import me.lucko.luckperms.lib.caffeine.cache.CacheLoader;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.Node;
import me.lucko.luckperms.lib.caffeine.cache.Pacer;
import me.lucko.luckperms.lib.caffeine.cache.SILMS;
import me.lucko.luckperms.lib.caffeine.cache.Scheduler;
import me.lucko.luckperms.lib.caffeine.cache.Ticker;
import me.lucko.luckperms.lib.caffeine.cache.WriteOrderDeque;

class SILMSW<K, V>
extends SILMS<K, V> {
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    SILMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder, cacheLoader, async);
        this.ticker = builder.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        this.pacer = builder.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(builder.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
        this.expiresAfterWriteNanos = expiresAfterWriteNanos;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

