/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.generation.feature;

import com.dfsek.terra.addons.generation.feature.config.BiomeFeatures;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.properties.PropertyKey;
import com.dfsek.terra.api.registry.key.StringIdentifiable;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.vector.Vector3Int;
import com.dfsek.terra.api.world.WritableWorld;
import com.dfsek.terra.api.world.chunk.generation.ProtoWorld;
import com.dfsek.terra.api.world.chunk.generation.stage.GenerationStage;
import com.dfsek.terra.api.world.chunk.generation.util.Column;
import com.dfsek.terra.api.world.info.WorldProperties;
import java.util.Collections;
import java.util.Random;

public class FeatureGenerationStage
implements GenerationStage,
StringIdentifiable {
    private final Platform platform;
    private final String id;
    private final String profile;
    private final int resolution;
    private final PropertyKey<BiomeFeatures> biomeFeaturesKey;

    public FeatureGenerationStage(Platform platform, String id, int resolution, PropertyKey<BiomeFeatures> biomeFeaturesKey) {
        this.platform = platform;
        this.id = id;
        this.profile = "feature_stage:" + id;
        this.resolution = resolution;
        this.biomeFeaturesKey = biomeFeaturesKey;
    }

    public void populate(ProtoWorld world) {
        this.platform.getProfiler().push(this.profile);
        int cx = world.centerChunkX() << 4;
        int cz = world.centerChunkZ() << 4;
        long seed = world.getSeed();
        for (int chunkX = 0; chunkX < 16; chunkX += this.resolution) {
            for (int chunkZ = 0; chunkZ < 16; chunkZ += this.resolution) {
                int tx = cx + chunkX;
                int tz = cz + chunkZ;
                world.getBiomeProvider().getColumn(tx, tz, (WorldProperties)world).forRanges(this.resolution, (min, max, biome) -> {
                    for (int subChunkX = 0; subChunkX < this.resolution; ++subChunkX) {
                        for (int subChunkZ = 0; subChunkZ < this.resolution; ++subChunkZ) {
                            int x = subChunkX + tx;
                            int z = subChunkZ + tz;
                            long coordinateSeed = (seed * 31L + (long)x) * 31L + (long)z;
                            Column column = world.column(x, z);
                            ((BiomeFeatures)biome.getContext().get(this.biomeFeaturesKey)).getFeatures().getOrDefault(this, Collections.emptyList()).forEach(feature -> {
                                this.platform.getProfiler().push(feature.getID());
                                if (feature.getDistributor().matches(x, z, seed)) {
                                    feature.getLocator().getSuitableCoordinates(column.clamp(min, max)).forEach(y -> feature.getStructure((WritableWorld)world, x, y, z).generate(Vector3Int.of((int)x, (int)y, (int)z), (WritableWorld)world, new Random(coordinateSeed * 31L + (long)y), Rotation.NONE));
                                }
                                this.platform.getProfiler().pop(feature.getID());
                            });
                        }
                    }
                });
            }
        }
        this.platform.getProfiler().pop(this.profile);
    }

    public String getID() {
        return this.id;
    }
}

