/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.util;

public class DataUtils {
    public static String humanSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        if (bytes < 0x10000000000L) {
            return String.format("%.2f GB", (double)bytes / 1.073741824E9);
        }
        if (bytes < 0x4000000000000L) {
            return String.format("%.2f TB", (double)bytes / 1.099511627776E12);
        }
        return String.format("%.2f PB", (double)bytes / 1.125899906842624E15);
    }

    public static String humanSpeed(double bytes) {
        if (bytes < 1024.0) {
            return String.format("%.2f B/s", bytes);
        }
        if (bytes < 1048576.0) {
            return String.format("%.2f KB/s", bytes / 1024.0);
        }
        if (bytes < 1.073741824E9) {
            return String.format("%.2f MB/s", bytes / 1048576.0);
        }
        if (bytes < 1.099511627776E12) {
            return String.format("%.2f GB/s", bytes / 1.073741824E9);
        }
        if (bytes < 1.125899906842624E15) {
            return String.format("%.2f TB/s", bytes / 1.099511627776E12);
        }
        return String.format("%.2f PB/s", bytes / 1.125899906842624E15);
    }
}

