/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.data;

import java.util.function.Consumer;
import net.creeperhost.levelio.data.Block;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.lib.BlockPos;

public class Section {
    private final int y;
    private final Chunk chunk;
    private Block[] blocks = new Block[4096];
    private boolean loaded = false;
    private Consumer<Section> loader;

    public Section(int y, Chunk chunk) {
        this.y = y;
        this.chunk = chunk;
    }

    public int getY() {
        return this.y;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setLoader(Consumer<Section> loader) {
        this.loader = loader;
    }

    private boolean loadSection() {
        if (this.loader != null) {
            this.loader.accept(this);
            this.loader = null;
            this.loaded = true;
            return true;
        }
        return false;
    }

    public Block getBlock(int sectionX, int sectionY, int sectionZ) {
        if (!this.loaded && !this.loadSection()) {
            return null;
        }
        int index = sectionY << 8 | sectionZ << 4 | sectionX;
        Block block = this.blocks[index];
        return block == null ? Block.newAirBlock() : block;
    }

    public Block getBlock(BlockPos pos) {
        return this.getBlock(pos.x & 0xF, pos.y & 0xF, pos.z & 0xF);
    }

    public boolean setBlock(int sectionX, int sectionY, int sectionZ, Block block) {
        if (!this.loaded) {
            this.loadSection();
        }
        int index = sectionY << 8 | sectionZ << 4 | sectionX;
        this.blocks[index] = block;
        return true;
    }

    public void set(int index, Block block) {
        this.blocks[index] = block;
    }

    public boolean hasBlock(BlockPos pos) {
        return this.hasBlock(pos.x & 0xF, pos.y & 0xF, pos.z & 0xF);
    }

    public boolean hasBlock(int sectionX, int sectionY, int sectionZ) {
        int index;
        if (!this.loaded) {
            this.loadSection();
        }
        return this.blocks[index = sectionY << 8 | sectionZ << 4 | sectionX] != null;
    }
}

