/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import owmii.powah.EnvHandler;
import owmii.powah.Powah;
import owmii.powah.api.energy.IEnergyConnector;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.CableTile;
import owmii.powah.config.v2.types.CableConfig;
import owmii.powah.inventory.CableContainer;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class CableBlock
extends AbstractEnergyBlock<CableConfig, CableBlock>
implements class_3737,
IEnergyConnector {
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    public static final class_2746 UP = class_2429.field_11327;
    public static final class_2746 DOWN = class_2429.field_11330;
    private static final class_265 CABLE = CableBlock.box(6.25, 6.25, 6.25, 9.75, 9.75, 9.75);
    private static final class_265[] MULTIPART = new class_265[]{CableBlock.box(6.5, 6.5, 0.0, 9.5, 9.5, 7.0), CableBlock.box(9.5, 6.5, 6.5, 16.0, 9.5, 9.5), CableBlock.box(6.5, 6.5, 9.5, 9.5, 9.5, 16.0), CableBlock.box(0.0, 6.5, 6.5, 6.5, 9.5, 9.5), CableBlock.box(6.5, 9.5, 6.5, 9.5, 16.0, 9.5), CableBlock.box(6.5, 0.0, 6.5, 9.5, 7.0, 9.5)};

    public CableBlock(class_4970.class_2251 properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public CableConfig getConfig() {
        return Powah.config().devices.cables;
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return EnvHandler.INSTANCE.createCable(pos, state, (Tier)this.variant);
    }

    @Override
    public boolean isChargeable(class_1799 stack) {
        return false;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 context) {
        class_265 voxelShape = CABLE;
        if (blockGetter instanceof class_1937) {
            class_1937 world = (class_1937)blockGetter;
            if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue() || this.canConnectEnergy(world, pos, class_2350.field_11043)) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)MULTIPART[0]);
            }
            if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue() || this.canConnectEnergy(world, pos, class_2350.field_11034)) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)MULTIPART[1]);
            }
            if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue() || this.canConnectEnergy(world, pos, class_2350.field_11035)) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)MULTIPART[2]);
            }
            if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue() || this.canConnectEnergy(world, pos, class_2350.field_11039)) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)MULTIPART[3]);
            }
            if (((Boolean)state.method_11654((class_2769)UP)).booleanValue() || this.canConnectEnergy(world, pos, class_2350.field_11036)) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)MULTIPART[4]);
            }
            if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue() || this.canConnectEnergy(world, pos, class_2350.field_11033)) {
                voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)MULTIPART[5]);
            }
        }
        return voxelShape;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        class_2586 class_25862;
        class_2680 newState = this.createCableState(level, pos);
        if (newState != state) {
            level.method_8652(pos, newState, 2);
        }
        if ((class_25862 = level.method_8321(pos)) instanceof CableTile) {
            CableTile cable = (CableTile)class_25862;
            EnumSet<class_2350> oldSides = EnumSet.copyOf(cable.energySides);
            cable.energySides.clear();
            for (class_2350 direction : class_2350.values()) {
                if (!this.canConnectEnergy(level, pos, direction)) continue;
                cable.energySides.add(direction);
            }
            if (!oldSides.equals(cable.energySides)) {
                cable.sync();
            }
        }
        super.method_9612(state, level, pos, block, fromPos, isMoving);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return this.createCableState(context.method_8045(), context.method_8037());
    }

    private class_2680 createCableState(class_1937 world, class_2338 pos) {
        class_2680 state = this.method_9564();
        boolean[] north = this.canAttach(state, world, pos, class_2350.field_11043);
        boolean[] south = this.canAttach(state, world, pos, class_2350.field_11035);
        boolean[] west = this.canAttach(state, world, pos, class_2350.field_11039);
        boolean[] east = this.canAttach(state, world, pos, class_2350.field_11034);
        boolean[] up = this.canAttach(state, world, pos, class_2350.field_11036);
        boolean[] down = this.canAttach(state, world, pos, class_2350.field_11033);
        class_3610 fluidState = world.method_8316(pos);
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(north[0] && !north[1]))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(south[0] && !south[1]))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(west[0] && !west[1]))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(east[0] && !east[1]))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(up[0] && !up[1]))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(down[0] && !down[1]))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        Optional<class_2350> hitSide = CableBlock.getHitSide(result.method_17784(), pos);
        if (hitSide.isPresent() && !this.canConnectEnergy(world, pos, hitSide.get())) {
            return class_1269.field_5814;
        }
        return super.method_9534(state, world, pos, player, hand, result);
    }

    @Override
    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, class_1661 inventory, AbstractTileEntity te, class_3965 result) {
        if (te instanceof CableTile) {
            return new CableContainer(id, inventory, (CableTile)te);
        }
        return super.getContainer(id, inventory, te, result);
    }

    @Override
    protected void additionalGuiData(class_2540 buffer, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        CableBlock.getHitSide(result.method_17784(), pos).ifPresent(side -> buffer.writeInt(side.method_10146()));
        super.additionalGuiData(buffer, state, world, pos, player, hand, result);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        class_2586 tileEntity = world.method_8321(pos);
        if (tileEntity instanceof CableTile) {
            CableTile cable = (CableTile)tileEntity;
            cable.energySides.clear();
            for (class_2350 direction : class_2350.values()) {
                if (!this.canConnectEnergy(world, pos, direction)) continue;
                cable.energySides.add(direction);
            }
            cable.sync();
        }
        super.method_9615(state, world, pos, oldState, isMoving);
    }

    public boolean[] canAttach(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return new boolean[]{world.method_8320(pos.method_10093(direction)).method_26204() == this || this.canConnectEnergy(world, pos, direction), this.canConnectEnergy(world, pos, direction)};
    }

    public boolean canConnectEnergy(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2586 tile = world.method_8321(pos.method_10093(direction));
        return !(tile instanceof CableTile) && EnvHandler.INSTANCE.hasEnergy(world, pos.method_10093(direction), direction.method_10153());
    }

    public static Optional<class_2350> getHitSide(class_243 hit, class_2338 pos) {
        double x = hit.field_1352 - (double)pos.method_10263();
        double y = hit.field_1351 - (double)pos.method_10264();
        double z = hit.field_1350 - (double)pos.method_10260();
        if (x > 0.0 && x < 0.4) {
            return Optional.of(class_2350.field_11039);
        }
        if (x > 0.6 && x < 1.0) {
            return Optional.of(class_2350.field_11034);
        }
        if (z > 0.0 && z < 0.4) {
            return Optional.of(class_2350.field_11043);
        }
        if (z > 0.6 && z < 1.0) {
            return Optional.of(class_2350.field_11035);
        }
        if (y > 0.6 && y < 1.0) {
            return Optional.of(class_2350.field_11036);
        }
        if (y > 0.0 && y < 0.4) {
            return Optional.of(class_2350.field_11033);
        }
        return Optional.empty();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
        super.method_9515(builder);
    }
}

