/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.gui;

import immersive_melodies.Config;
import immersive_melodies.client.gui.widget.MelodyListWidget;
import immersive_melodies.client.gui.widget.TexturedButtonWidget;
import immersive_melodies.cobalt.network.NetworkHandler;
import immersive_melodies.network.PacketSplitter;
import immersive_melodies.network.c2s.ItemActionMessage;
import immersive_melodies.network.c2s.MelodyDeleteRequest;
import immersive_melodies.resources.ClientMelodyManager;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.util.MidiConverter;
import immersive_melodies.util.MidiParser;
import immersive_melodies.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ImmersiveMelodiesScreen
extends class_437 {
    public static final class_2960 BACKGROUND_TEXTURE = new class_2960("immersive_melodies:textures/gui/paper.png");
    private MelodyListWidget list;
    private class_342 search;
    private class_2561 error;
    private long lastError;
    @Nullable
    private class_2960 selected = null;

    private void setError(class_2561 error) {
        this.error = error;
        this.lastError = System.currentTimeMillis();
        this.search.method_1852("");
        this.search.method_1887(null);
    }

    public ImmersiveMelodiesScreen() {
        super((class_2561)class_2561.method_43471((String)"itemGroup.immersive_melodies.immersive_melodies_tab"));
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        this.search = new class_342(this.field_22793, this.field_22789 / 2 - 70, this.field_22790 / 2 - 103, 140, 20, (class_2561)class_2561.method_43471((String)"immersive_melodies.search"));
        this.search.method_1880(128);
        this.search.method_1863(a -> {
            this.refreshPage();
            this.search.method_1887(null);
            this.list.method_25307(0.0);
        });
        this.search.method_1858(false);
        this.search.method_1868(0x808080);
        this.search.method_1887("Search");
        this.method_48265((class_364)this.search);
        this.list = new MelodyListWidget(this.field_22787, this);
        this.refreshPage();
    }

    private void openHelp() {
        try {
            class_156.method_668().method_673(URI.create("https://github.com/Luke100000/ImmersiveMelodies/wiki/Custom-Melodies"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void method_29638(List<Path> paths) {
        PathMatcher midiMatcher = FileSystems.getDefault().getPathMatcher("glob:*{.mid,.midi,.MID,.MIDI}");
        PathMatcher abcMatcher = FileSystems.getDefault().getPathMatcher("glob:*{.abc,.ABC}");
        for (Path path : paths) {
            try {
                String rawName = path.getFileName().toString();
                String name = rawName.substring(0, rawName.lastIndexOf(46));
                if (midiMatcher.matches(path.getFileName())) {
                    FileInputStream inputStream = new FileInputStream(path.toFile());
                    this.parseMidi(name, inputStream);
                    continue;
                }
                if (!abcMatcher.matches(path.getFileName())) continue;
                byte[] bytes = Files.readAllBytes(path);
                class_310.method_1551().execute(() -> {
                    try {
                        MidiConverter.Response request = MidiConverter.request(bytes);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(request.getBody());
                        this.parseMidi(name, inputStream);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.setError((class_2561)class_2561.method_43471((String)"immersive_melodies.error.empty"));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseMidi(String name, InputStream inputStream) {
        Melody melody = MidiParser.parseMidi(inputStream, name);
        if (!melody.getTracks().isEmpty()) {
            PacketSplitter.sendToServer(name, melody);
            this.search.method_1852(name);
            this.list.method_25307(0.0);
        } else {
            this.setError((class_2561)class_2561.method_43471((String)"immersive_melodies.error.empty"));
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        int x = (this.field_22789 - 192) / 2;
        int y = (this.field_22790 - 230) / 2;
        context.method_25302(BACKGROUND_TEXTURE, x, y, 0, 0, 192, 215);
        if (!Config.getInstance().clickedHelp) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"immersive_melodies.read"), this.field_22789 / 2 + 55, this.field_22790 / 2 + 69 + 17);
        }
        if (this.error != null && System.currentTimeMillis() - this.lastError < 5000L) {
            context.method_27534(this.field_22793, this.error, this.field_22789 / 2, this.field_22790 / 2 - 103, 0xFF0000);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void refreshPage() {
        this.method_37067();
        this.method_37063((class_364)this.search);
        this.method_37063((class_364)this.list);
        this.list.method_25339();
        Object lastPath = "";
        for (Map.Entry entry : ClientMelodyManager.getMelodiesList().entrySet().stream().filter(e -> this.search.method_1882().isEmpty() || ((MelodyDescriptor)e.getValue()).getName().toLowerCase(Locale.ROOT).contains(this.search.method_1882().toLowerCase(Locale.ROOT))).sorted((a, b) -> {
            int primarySortB;
            int primarySortA = ImmersiveMelodiesScreen.getSortIndex(a);
            if (primarySortA != (primarySortB = ImmersiveMelodiesScreen.getSortIndex(b))) {
                return primarySortB - primarySortA;
            }
            return ((MelodyDescriptor)a.getValue()).getName().compareTo(((MelodyDescriptor)b.getValue()).getName());
        }).toList()) {
            String dir = Utils.removeLastPart(((class_2960)entry.getKey()).method_12832(), "/");
            String path = ((class_2960)entry.getKey()).method_12836() + "/" + dir;
            if (!path.equals(lastPath)) {
                this.list.addEntry(new class_2960(path), (class_2561)class_2561.method_43470((String)dir).method_27692(class_124.field_1056).method_27692(class_124.field_1080), null);
                lastPath = path;
            }
            this.list.addEntry((class_2960)entry.getKey(), (class_2561)class_2561.method_43470((String)((MelodyDescriptor)entry.getValue()).getName()), () -> {
                NetworkHandler.sendToServer(new ItemActionMessage(ItemActionMessage.State.PLAY, (class_2960)entry.getKey()));
                this.selected = (class_2960)entry.getKey();
                this.refreshPage();
            });
        }
        int y = this.field_22790 / 2 + 69;
        this.method_37063((class_364)new TexturedButtonWidget(this.field_22789 / 2 - 75, y, 16, 16, BACKGROUND_TEXTURE, 240, 0, 256, 256, class_2561.method_30163(null), button -> this.method_25419(), () -> List.of(class_2561.method_43471((String)"immersive_melodies.close").method_30937())));
        if (this.selected != null && Utils.canDelete(this.selected, (class_1657)class_310.method_1551().field_1724)) {
            this.method_37063((class_364)new TexturedButtonWidget(this.field_22789 / 2 + 30, y, 16, 16, BACKGROUND_TEXTURE, 240, 16, 256, 256, class_2561.method_30163(null), button -> {
                NetworkHandler.sendToServer(new MelodyDeleteRequest(this.selected));
                this.selected = null;
            }, () -> List.of(class_2561.method_43471((String)"immersive_melodies.delete").method_30937())));
        }
        this.method_37063((class_364)new TexturedButtonWidget(this.field_22789 / 2 - 10 - 8, y, 16, 16, BACKGROUND_TEXTURE, 224, 32, 256, 256, class_2561.method_30163(null), button -> NetworkHandler.sendToServer(new ItemActionMessage(ItemActionMessage.State.PAUSE)), () -> List.of(class_2561.method_43471((String)"immersive_melodies.pause").method_30937())));
        this.method_37063((class_364)new TexturedButtonWidget(this.field_22789 / 2, y, 16, 16, BACKGROUND_TEXTURE, 240, 32, 256, 256, class_2561.method_30163(null), button -> NetworkHandler.sendToServer(new ItemActionMessage(ItemActionMessage.State.CONTINUE)), () -> List.of(class_2561.method_43471((String)"immersive_melodies.play").method_30937())));
        this.method_37063((class_364)new TexturedButtonWidget(this.field_22789 / 2 + 50, y, 16, 16, BACKGROUND_TEXTURE, 208, 32, 256, 256, class_2561.method_30163(null), button -> {
            this.openHelp();
            if (!Config.getInstance().clickedHelp) {
                Config.getInstance().clickedHelp = true;
                Config.getInstance().save();
            }
        }, () -> List.of(class_2561.method_43471((String)"immersive_melodies.help").method_30937())));
    }

    private static int getSortIndex(Map.Entry<class_2960, MelodyDescriptor> entry) {
        return Utils.ownsMelody(entry.getKey(), (class_1657)class_310.method_1551().field_1724) ? 2 : (Utils.isPlayerMelody(entry.getKey()) ? 0 : 1);
    }

    public class_327 getTextRenderer() {
        return this.field_22793;
    }
}

