/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.util;

import immersive_melodies.resources.Melody;
import immersive_melodies.resources.Note;
import immersive_melodies.resources.Track;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;

public class MidiParser {
    public static Melody parseMidi(InputStream inputStream, String midiName) {
        Melody melody = new Melody(midiName);
        try {
            Sequence sequence = MidiSystem.getSequence(inputStream);
            LinkedList sharedEvents = new LinkedList();
            for (javax.sound.midi.Track track : sequence.getTracks()) {
                MidiParser.getEvents(track).stream().filter(event -> {
                    MetaMessage m;
                    MidiMessage patt774$temp = event.getMessage();
                    return patt774$temp instanceof MetaMessage && (m = (MetaMessage)patt774$temp).getType() == 81;
                }).forEach(sharedEvents::add);
            }
            int trackNr = 1;
            for (javax.sound.midi.Track track : sequence.getTracks()) {
                List<MidiEvent> events = MidiParser.getEvents(track);
                events.addAll(0, sharedEvents);
                events.sort((a, b) -> (int)(a.getTick() - b.getTick()));
                int bpm = 120;
                long lastTick = 0L;
                double lastMs = 0.0;
                Object name = "Track " + trackNr;
                LinkedList<Note> notes = new LinkedList<Note>();
                HashMap<Integer, Note.Builder> currentNotes = new HashMap<Integer, Note.Builder>();
                for (MidiEvent event2 : events) {
                    int note;
                    MidiMessage message = event2.getMessage();
                    if (message instanceof MetaMessage) {
                        MetaMessage metaMessage = (MetaMessage)message;
                        byte[] data = metaMessage.getData();
                        int type = metaMessage.getType();
                        if (type == 3) {
                            if (sequence.getTracks().length > 1) {
                                name = new String(data).strip();
                            }
                        } else if (type == 81) {
                            int microsecondsPerBeat = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                            bpm = Math.round(6.0E7f / (float)microsecondsPerBeat);
                        }
                    }
                    if (!(message instanceof ShortMessage)) continue;
                    ShortMessage sm = (ShortMessage)message;
                    int command = sm.getCommand();
                    long tick = event2.getTick();
                    int ms = (int)((double)((tick - lastTick) * 60L * 1000L / (long)sequence.getResolution() / (long)bpm) + lastMs);
                    lastTick = tick;
                    lastMs = ms;
                    if (command == 144 && sm.getData2() == 0) {
                        command = 128;
                    }
                    if (command == 144) {
                        note = sm.getData1();
                        int velocity = sm.getData2();
                        if (currentNotes.containsKey(note)) {
                            Note.Builder previousNote = (Note.Builder)currentNotes.get(note);
                            previousNote.sustain = ms - previousNote.time;
                        }
                        currentNotes.put(note, new Note.Builder(note, velocity, ms));
                        continue;
                    }
                    if (command != 128) continue;
                    note = sm.getData1();
                    Note.Builder noteBuilder = (Note.Builder)currentNotes.get(note);
                    currentNotes.remove(note);
                    if (noteBuilder == null) continue;
                    noteBuilder.length = ms - noteBuilder.time;
                    notes.add(noteBuilder.build());
                }
                if (notes.size() <= 0) continue;
                ++trackNr;
                notes.sort(Comparator.comparingInt(Note::getTime));
                melody.addTrack(new Track((String)name, notes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return melody;
    }

    private static List<MidiEvent> getEvents(javax.sound.midi.Track track) {
        LinkedList<MidiEvent> events = new LinkedList<MidiEvent>();
        for (int i = 0; i < track.size(); ++i) {
            events.add(track.get(i));
        }
        return events;
    }
}

