/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.api;

import draylar.tiered.Tiered;
import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.config.ConfigInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.stats.Skill;
import net.libz.util.SortList;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ModifierUtils {
    @Nullable
    public static class_2960 getRandomAttributeIDFor(@Nullable class_1657 playerEntity, class_1792 item, boolean reforge) {
        int i;
        ArrayList potentialAttributes = new ArrayList();
        ArrayList<Integer> attributeWeights = new ArrayList<Integer>();
        Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
            if (attribute.isValid(class_7923.field_41178.method_10221((Object)item)) && (attribute.getWeight() > 0 || reforge)) {
                potentialAttributes.add(new class_2960(attribute.getID()));
                attributeWeights.add(reforge ? attribute.getWeight() + 1 : attribute.getWeight());
            }
        });
        if (potentialAttributes.size() <= 0) {
            return null;
        }
        if (reforge && attributeWeights.size() > 2) {
            SortList.concurrentSort(attributeWeights, (List[])new List[]{attributeWeights, potentialAttributes});
            int maxWeight = (Integer)attributeWeights.get(attributeWeights.size() - 1);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= maxWeight / 2) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * ConfigInit.CONFIG.reforge_modifier));
            }
        }
        if (Tiered.isLevelZLoaded && playerEntity != null) {
            int newMaxWeight = (Integer)Collections.max(attributeWeights);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= newMaxWeight / 3) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * (1.0f - ConfigInit.CONFIG.levelz_reforge_modifier * (float)((PlayerStatsManagerAccess)playerEntity).getPlayerStatsManager().getSkillLevel(Skill.SMITHING))));
            }
        }
        if (playerEntity != null) {
            int luckMaxWeight = (Integer)Collections.max(attributeWeights);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= luckMaxWeight / 3) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * (1.0f - ConfigInit.CONFIG.luck_reforge_modifier * playerEntity.method_7292())));
            }
        }
        if (potentialAttributes.size() > 0) {
            int totalWeight = 0;
            for (Integer weight : attributeWeights) {
                totalWeight += weight.intValue();
            }
            int randomChoice = new Random().nextInt(totalWeight);
            SortList.concurrentSort(attributeWeights, (List[])new List[]{attributeWeights, potentialAttributes});
            for (int i2 = 0; i2 < attributeWeights.size(); ++i2) {
                if (randomChoice < (Integer)attributeWeights.get(i2)) {
                    return (class_2960)potentialAttributes.get(i2);
                }
                randomChoice -= ((Integer)attributeWeights.get(i2)).intValue();
            }
            return (class_2960)potentialAttributes.get(new Random().nextInt(potentialAttributes.size()));
        }
        return null;
    }

    public static void setItemStackAttribute(@Nullable class_1657 playerEntity, class_1799 stack, boolean reforge) {
        class_2960 potentialAttributeID;
        if (stack.method_7941("Tiered") == null && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(playerEntity, stack.method_7909(), reforge)) != null) {
            stack.method_7911("Tiered").method_10582("Tier", potentialAttributeID.toString());
            HashMap<String, Object> nbtMap = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(potentialAttributeID.toString())).getNbtValues();
            List<AttributeTemplate> attributeList = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(potentialAttributeID.toString())).getAttributes();
            for (int i = 0; i < attributeList.size(); ++i) {
                if (!attributeList.get(i).getAttributeTypeID().equals("tiered:generic.durable")) continue;
                if (nbtMap == null) {
                    nbtMap = new HashMap();
                }
                nbtMap.put("durable", (double)Math.round(attributeList.get(i).getEntityAttributeModifier().method_6186() * 100.0) / 100.0);
                break;
            }
            if (nbtMap != null) {
                class_2487 nbtCompound = stack.method_7969();
                for (Map.Entry<String, Object> entry : nbtMap.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        nbtCompound.method_10582(key, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        nbtCompound.method_10556(key, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    if (Math.abs((Double)value) % 1.0 < 1.0E-4) {
                        nbtCompound.method_10569(key, (int)Math.round((Double)value));
                        continue;
                    }
                    nbtCompound.method_10549(key, (double)Math.round((Double)value * 100.0) / 100.0);
                }
                stack.method_7980(nbtCompound);
            }
        }
    }

    public static void removeItemStackAttribute(class_1799 itemStack) {
        if (itemStack.method_7985() && itemStack.method_7941("Tiered") != null) {
            class_2960 tier = new class_2960(itemStack.method_7911("Tiered").method_10558("Tier"));
            if (Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier) != null) {
                int i;
                HashMap<String, Object> nbtMap = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier).getNbtValues();
                ArrayList nbtKeys = new ArrayList();
                if (nbtMap != null) {
                    nbtKeys.addAll(nbtMap.keySet().stream().toList());
                }
                List<AttributeTemplate> attributeList = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier).getAttributes();
                for (i = 0; i < attributeList.size(); ++i) {
                    if (!attributeList.get(i).getAttributeTypeID().equals("tiered:generic.durable")) continue;
                    nbtKeys.add("durable");
                    break;
                }
                if (!nbtKeys.isEmpty()) {
                    for (i = 0; i < nbtKeys.size(); ++i) {
                        if (((String)nbtKeys.get(i)).equals("Damage")) continue;
                        itemStack.method_7969().method_10551((String)nbtKeys.get(i));
                    }
                }
            }
            itemStack.method_7983("Tiered");
        }
    }

    private ModifierUtils() {
    }
}

