/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.datagen.builder.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeAction;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeCondition;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeTrigger;
import wraith.fabricaeexnihilo.recipe.util.BlockIngredient;
import wraith.fabricaeexnihilo.recipe.util.EntityStack;
import wraith.fabricaeexnihilo.recipe.util.FluidIngredient;

public class BarrelRecipeJsonBuilder
implements class_5797 {
    private final BarrelRecipeTrigger trigger;
    private final List<BarrelRecipeCondition> conditions = new ArrayList<BarrelRecipeCondition>();
    private final List<BarrelRecipeAction> actions = new ArrayList<BarrelRecipeAction>();
    private boolean hasStateCondition = false;
    private int duration = -1;
    private class_1792 icon = null;

    private BarrelRecipeJsonBuilder(BarrelRecipeTrigger trigger) {
        this.trigger = trigger;
    }

    public static BarrelRecipeJsonBuilder tickTriggered(float chance) {
        return new BarrelRecipeJsonBuilder(new BarrelRecipeTrigger.Tick(chance));
    }

    public static BarrelRecipeJsonBuilder tickTriggered() {
        return BarrelRecipeJsonBuilder.tickTriggered(1.0f);
    }

    public static BarrelRecipeJsonBuilder itemTriggered(class_1856 ingredient) {
        return new BarrelRecipeJsonBuilder(new BarrelRecipeTrigger.ItemInserted(ingredient));
    }

    public static BarrelRecipeJsonBuilder itemTriggered(class_1935 ... items) {
        return BarrelRecipeJsonBuilder.itemTriggered(class_1856.method_8091((class_1935[])items));
    }

    public static BarrelRecipeJsonBuilder itemTriggered(class_6862<class_1792> items) {
        return BarrelRecipeJsonBuilder.itemTriggered(class_1856.method_8106(items));
    }

    public BarrelRecipeJsonBuilder fluid(FluidIngredient fluid) {
        if (this.hasStateCondition) {
            throw new IllegalStateException("Multiple state conditions are not a good idea");
        }
        this.conditions.add(new BarrelRecipeCondition.FluidIn(fluid));
        this.hasStateCondition = true;
        return this;
    }

    public BarrelRecipeJsonBuilder fluid(class_3611 fluid) {
        this.fluid(FluidIngredient.single(fluid));
        return this;
    }

    public BarrelRecipeJsonBuilder fluid(class_6862<class_3611> tag) {
        this.fluid(FluidIngredient.tag(tag));
        return this;
    }

    public BarrelRecipeJsonBuilder above(BlockIngredient block) {
        this.conditions.add(new BarrelRecipeCondition.BlockAbove(block));
        return this;
    }

    public BarrelRecipeJsonBuilder above(class_2248 block) {
        return this.above(BlockIngredient.single(block));
    }

    public BarrelRecipeJsonBuilder above(FluidIngredient fluid) {
        this.conditions.add(new BarrelRecipeCondition.FluidAbove(fluid));
        return this;
    }

    public BarrelRecipeJsonBuilder above(class_3611 fluid) {
        return this.above(FluidIngredient.single(fluid));
    }

    public BarrelRecipeJsonBuilder above(class_6862<class_3611> tag) {
        return this.above(FluidIngredient.tag(tag));
    }

    public BarrelRecipeJsonBuilder below(BlockIngredient block) {
        this.conditions.add(new BarrelRecipeCondition.BlockBelow(block));
        return this;
    }

    public BarrelRecipeJsonBuilder below(class_2248 block) {
        return this.below(BlockIngredient.single(block));
    }

    public BarrelRecipeJsonBuilder duration(int barrelTicks) {
        this.duration = barrelTicks;
        return this;
    }

    public BarrelRecipeJsonBuilder instant() {
        this.duration = 0;
        return this;
    }

    public BarrelRecipeJsonBuilder spawnEntity(EntityStack stack) {
        this.actions.add(new BarrelRecipeAction.SpawnEntity(stack));
        return this;
    }

    public BarrelRecipeJsonBuilder spawnEntity(class_1299<?> type) {
        return this.spawnEntity(new EntityStack(type, 1));
    }

    public BarrelRecipeJsonBuilder spawnEntity(class_1299<?> type, class_2487 nbt) {
        return this.spawnEntity(new EntityStack(type, 1, nbt));
    }

    public BarrelRecipeJsonBuilder storeItem(class_1799 stack) {
        if (this.icon == null) {
            this.icon((class_1935)stack.method_7909());
        }
        this.actions.add(new BarrelRecipeAction.StoreItem(stack));
        return this;
    }

    public BarrelRecipeJsonBuilder storeItem(class_1935 item) {
        return this.storeItem(item.method_8389().method_7854());
    }

    public BarrelRecipeJsonBuilder dropItem(class_1799 stack) {
        this.actions.add(new BarrelRecipeAction.DropItem(stack));
        return this;
    }

    public BarrelRecipeJsonBuilder dropItem(class_1935 item) {
        return this.dropItem(item.method_8389().method_7854());
    }

    public BarrelRecipeJsonBuilder storeFluid(FluidVariant fluid, long amount) {
        this.actions.add(new BarrelRecipeAction.StoreFluid(fluid, amount));
        return this;
    }

    public BarrelRecipeJsonBuilder storeFluid(class_3611 fluid, long amount) {
        return this.storeFluid(FluidVariant.of((class_3611)fluid), amount);
    }

    public BarrelRecipeJsonBuilder storeFluid(class_3611 fluid) {
        return this.storeFluid(fluid, fluid == class_3612.field_15906 ? 0L : 81000L);
    }

    public BarrelRecipeJsonBuilder consumeFluid(FluidIngredient fluid, long amount) {
        if (this.hasStateCondition) {
            throw new IllegalStateException("Multiple state conditions are not a good idea");
        }
        this.actions.add(new BarrelRecipeAction.ConsumeFluid(fluid, amount));
        this.hasStateCondition = true;
        return this;
    }

    public BarrelRecipeJsonBuilder consumeFluid(class_6862<class_3611> tag, long amount) {
        return this.consumeFluid(FluidIngredient.tag(tag), amount);
    }

    public BarrelRecipeJsonBuilder consumeFluid(class_3611 fluid, long amount) {
        return this.consumeFluid(FluidIngredient.single(fluid), amount);
    }

    public BarrelRecipeJsonBuilder convertBlock(BlockIngredient filter, class_2680 result) {
        if (this.icon == null) {
            this.icon((class_1935)result.method_26204());
        }
        this.actions.add(new BarrelRecipeAction.ConvertBlock(filter, result));
        return this;
    }

    public BarrelRecipeJsonBuilder convertBlock(class_2248 from, class_2248 to) {
        return this.convertBlock(BlockIngredient.single(from), to.method_9564());
    }

    public BarrelRecipeJsonBuilder fillCompost(class_1799 item, float amount) {
        if (this.hasStateCondition) {
            throw new IllegalStateException("Multiple state conditions are not a good idea");
        }
        this.icon((class_1935)item.method_7909());
        this.actions.add(new BarrelRecipeAction.FillCompost(item, amount));
        this.hasStateCondition = true;
        return this;
    }

    public BarrelRecipeJsonBuilder fillCompost(class_1792 item, float amount) {
        return this.fillCompost(new class_1799((class_1935)item), amount);
    }

    public BarrelRecipeJsonBuilder icon(class_1935 icon) {
        this.icon = icon.method_8389();
        return this;
    }

    public class_5797 method_33530(String name, class_184 conditions) {
        throw new UnsupportedOperationException();
    }

    public class_5797 method_33529(@Nullable String group) {
        throw new UnsupportedOperationException();
    }

    public class_1792 method_36441() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void method_10431(Consumer<class_2444> exporter) {
        throw new UnsupportedOperationException();
    }

    public void method_36443(Consumer<class_2444> exporter, String recipePath) {
        this.method_17972(exporter, new class_2960(recipePath));
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        if (this.duration == -1) {
            throw new IllegalStateException("Duration not set");
        }
        if (this.actions.size() == 0) {
            throw new IllegalStateException("No actions set");
        }
        if (this.icon == null) {
            throw new IllegalStateException("No icon set");
        }
        if (!this.hasStateCondition) {
            throw new IllegalStateException("No state condition set, this recipe could trigger on all kinds of barrels");
        }
        exporter.accept(new Provider(this.duration, this.icon, this.trigger, this.actions, this.conditions, recipeId));
    }

    private record Provider(int duration, class_1792 icon, BarrelRecipeTrigger trigger, List<BarrelRecipeAction> actions, List<BarrelRecipeCondition> conditions, class_2960 id) implements class_2444
    {
        public void method_10416(JsonObject json) {
            json.add("trigger", (JsonElement)this.trigger.toJson());
            JsonArray actions = new JsonArray();
            this.actions.forEach(action -> actions.add((JsonElement)action.toJson()));
            json.add("actions", (JsonElement)actions);
            if (!this.conditions.isEmpty()) {
                JsonArray conditions = new JsonArray();
                this.conditions.forEach(action -> conditions.add((JsonElement)action.toJson()));
                json.add("conditions", (JsonElement)conditions);
            }
            if (this.duration != 0) {
                json.addProperty("duration", (Number)this.duration);
            }
            json.addProperty("icon", class_7923.field_41178.method_10221((Object)this.icon).toString());
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return ModRecipes.BARREL_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

