/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.datagen.builder.recipe;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.compatibility.DefaultApiModule;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.util.CodecUtils;

public class SieveRecipeJsonBuilder
implements class_5797 {
    private static final Codec<Map<class_1792, double[]>> ROLLS_CODEC = Codec.unboundedMap((Codec)class_7923.field_41178.method_39673(), (Codec)Codec.DOUBLE.listOf().xmap(doubles -> ArrayUtils.toPrimitive((Double[])doubles.toArray(new Double[0])), array -> List.of(ArrayUtils.toObject((double[])array))));
    private final class_1799 result;
    private final List<Segment> segments = new ArrayList<Segment>();
    private Segment currentSegment;

    private SieveRecipeJsonBuilder(class_1799 result) {
        this.result = result;
    }

    public static SieveRecipeJsonBuilder of(class_1799 result) {
        return new SieveRecipeJsonBuilder(result);
    }

    public static SieveRecipeJsonBuilder of(class_1935 result) {
        return new SieveRecipeJsonBuilder(new class_1799(result));
    }

    public SieveRecipeJsonBuilder from(class_1856 input, String name) {
        if (this.currentSegment != null) {
            this.segments.add(this.currentSegment);
        }
        this.currentSegment = new Segment(input, false, name, new HashMap<class_1792, double[]>());
        return this;
    }

    public SieveRecipeJsonBuilder from(class_1935 input) {
        return this.from(class_1856.method_8091((class_1935[])new class_1935[]{input}), class_7923.field_41178.method_10221((Object)input.method_8389()).method_12832());
    }

    public SieveRecipeJsonBuilder fromWaterlogged(class_1856 input, String name) {
        if (this.currentSegment != null) {
            this.segments.add(this.currentSegment);
        }
        this.currentSegment = new Segment(input, true, name, new HashMap<class_1792, double[]>());
        return this;
    }

    public SieveRecipeJsonBuilder fromWaterlogged(class_1935 input) {
        return this.fromWaterlogged(class_1856.method_8091((class_1935[])new class_1935[]{input}), class_7923.field_41178.method_10221((Object)input.method_8389()).method_12832());
    }

    public SieveRecipeJsonBuilder mesh(class_1792 mesh, double ... chances) {
        if (this.currentSegment == null) {
            throw new IllegalStateException("No active segment");
        }
        this.currentSegment.rolls.put(mesh, chances);
        return this;
    }

    public SieveRecipeJsonBuilder meshes(Map<class_1792, double[]> meshes) {
        meshes.forEach(this::mesh);
        return this;
    }

    public SieveRecipeJsonBuilder stringMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.stringMesh, chances);
    }

    public SieveRecipeJsonBuilder flintMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.flintMesh, chances);
    }

    public SieveRecipeJsonBuilder ironMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.ironMesh, chances);
    }

    public SieveRecipeJsonBuilder diamondMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.diamondMesh, chances);
    }

    public SieveRecipeJsonBuilder netheriteMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.netheriteMesh, chances);
    }

    public SieveRecipeJsonBuilder copperMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.copperMesh, chances);
    }

    public SieveRecipeJsonBuilder goldMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.goldMesh, chances);
    }

    public SieveRecipeJsonBuilder emeraldMesh(double ... chances) {
        return this.mesh(DefaultApiModule.INSTANCE.emeraldMesh, chances);
    }

    public class_5797 method_33530(String name, class_184 conditions) {
        throw new UnsupportedOperationException();
    }

    public class_5797 method_33529(@Nullable String group) {
        throw new UnsupportedOperationException();
    }

    public class_1792 method_36441() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void method_10431(Consumer<class_2444> exporter) {
        throw new UnsupportedOperationException();
    }

    public void method_36443(Consumer<class_2444> exporter, String recipePath) {
        this.method_17972(exporter, new class_2960(recipePath));
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        if (this.currentSegment == null) {
            throw new IllegalStateException("No segments");
        }
        this.segments.add(this.currentSegment);
        for (Segment segment : this.segments) {
            exporter.accept(new Provider(this.result, segment, recipeId, this.segments.size() > 1));
        }
    }

    private record Segment(class_1856 input, boolean waterlogged, String name, Map<class_1792, double[]> rolls) {
    }

    private record Provider(class_1799 result, Segment segment, class_2960 id, boolean useLongId) implements class_2444
    {
        public void method_10416(JsonObject json) {
            json.add("result", CodecUtils.toJson(CodecUtils.ITEM_STACK, this.result));
            json.add("input", this.segment.input.method_8089());
            json.addProperty("waterlogged", Boolean.valueOf(this.segment.waterlogged));
            json.add("rolls", CodecUtils.toJson(ROLLS_CODEC, this.segment.rolls));
        }

        public class_2960 method_10417() {
            return this.useLongId ? this.id.method_48331("_from_" + this.segment.name) : this.id;
        }

        public class_1865<?> method_17800() {
            return ModRecipes.SIEVE_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

