/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels;

import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlock;
import wraith.fabricaeexnihilo.modules.barrels.BarrelFluidStorage;
import wraith.fabricaeexnihilo.modules.barrels.BarrelItemStorage;
import wraith.fabricaeexnihilo.modules.barrels.BarrelState;
import wraith.fabricaeexnihilo.modules.base.BaseBlockEntity;
import wraith.fabricaeexnihilo.modules.base.EnchantableBlockEntity;
import wraith.fabricaeexnihilo.modules.base.EnchantmentContainer;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipe;

public class BarrelBlockEntity
extends BaseBlockEntity
implements EnchantableBlockEntity {
    public static final class_2960 BLOCK_ENTITY_ID = FabricaeExNihilo.id("barrel");
    public static final class_2591<BarrelBlockEntity> TYPE = FabricBlockEntityTypeBuilder.create(BarrelBlockEntity::new, (class_2248[])((class_2248[])ModBlocks.BARRELS.values().toArray(new BarrelBlock[0]))).build(null);
    public final BarrelFluidStorage fluidStorage;
    public final BarrelItemStorage itemStorage;
    private final EnchantmentContainer enchantments = new EnchantmentContainer();
    private int tickCounter;
    private class_2960 lazeRecipeId;
    private BarrelState state = BarrelState.EMPTY;
    private FluidVariant fluid = FluidVariant.blank();
    private long fluidAmount = 0L;
    private class_1799 stack = class_1799.field_8037;
    private float compostLevel = 0.0f;
    private BarrelRecipe recipe = null;
    private float recipeProgress = 0.0f;

    public BarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
        this.fluidStorage = new BarrelFluidStorage(this);
        this.itemStorage = new BarrelItemStorage(this);
        this.tickCounter = this.field_11863 == null ? ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().tickRate() : this.field_11863.field_9229.method_43048(((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().tickRate());
    }

    public class_1269 activate(@Nullable class_1657 player, @Nullable class_1268 hand) {
        if (this.field_11863 == null || player == null || hand == null || this.isCrafting()) {
            return class_1269.field_5811;
        }
        if (this.state == BarrelState.ITEM) {
            this.dropInventoryAtPlayer(player);
            return class_1269.field_5812;
        }
        return this.insertFromHand(player, hand);
    }

    public void dropInventoryAtPlayer(class_1657 player) {
        if (this.field_11863 == null || this.state != BarrelState.ITEM) {
            return;
        }
        class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0625, (double)this.field_11867.method_10260() + 0.5, this.stack);
        entity.method_18799(player.method_19538().method_1020(entity.method_19538()).method_1029().method_1021(0.5));
        if (this.field_11863 != null) {
            this.field_11863.method_8649((class_1297)entity);
        }
        this.setItem(class_1799.field_8037);
        this.method_5431();
    }

    public int getEfficiencyMultiplier() {
        return 1 + this.enchantments.getEnchantmentLevel(class_1893.field_9131);
    }

    @Override
    public EnchantmentContainer getEnchantmentContainer() {
        return this.enchantments;
    }

    public class_1269 insertFromHand(class_1657 player, class_1268 hand) {
        if (this.field_11863 == null) {
            return class_1269.field_5811;
        }
        class_1799 held = player.method_5998(hand);
        if (held.method_7960()) {
            return class_1269.field_5811;
        }
        try (Transaction t = Transaction.openOuter();){
            int inserted = (int)this.itemStorage.insert(ItemVariant.of((class_1799)held), (long)held.method_7947(), (TransactionContext)t);
            if (inserted != 0) {
                if (!player.method_7337()) {
                    held.method_7934(inserted);
                }
                t.commit();
                class_1269 class_12692 = class_1269.field_5812;
                return class_12692;
            }
        }
        Storage bucketFluidStorage = (Storage)FluidStorage.ITEM.find(held, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
        if (bucketFluidStorage == null) {
            return class_1269.field_5811;
        }
        try (Transaction t = Transaction.openOuter();){
            long moved;
            ResourceAmount amount = StorageUtil.findExtractableContent((Storage)bucketFluidStorage, (TransactionContext)t);
            if (amount == null) {
                FluidVariant fluid = this.fluidStorage.getResource();
                moved = StorageUtil.move((Storage)this.fluidStorage, (Storage)bucketFluidStorage, fluidVariant -> true, (long)81000L, (TransactionContext)t);
                if (moved != 0L) {
                    this.field_11863.method_8396(null, this.field_11867, FluidVariantAttributes.getFillSound((FluidVariant)fluid), class_3419.field_15245, 1.0f, 1.0f);
                }
            } else {
                moved = player.method_7337() ? this.fluidStorage.insert((FluidVariant)amount.resource(), amount.amount(), (TransactionContext)t) : StorageUtil.move((Storage)bucketFluidStorage, (Storage)this.fluidStorage, fluidVariant -> true, (long)81000L, (TransactionContext)t);
                if (moved != 0L) {
                    this.field_11863.method_8396(null, this.field_11867, FluidVariantAttributes.getEmptySound((FluidVariant)this.fluidStorage.getResource()), class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            if (moved != 0L) {
                t.commit();
                class_1269 class_12693 = class_1269.field_5812;
                return class_12693;
            }
        }
        return class_1269.field_5811;
    }

    public boolean isFireproof() {
        BarrelBlock barrel;
        class_2248 class_22482 = this.method_11010().method_26204();
        return class_22482 instanceof BarrelBlock && (barrel = (BarrelBlock)class_22482).isFireproof();
    }

    public void method_11007(class_2487 nbt) {
        nbt.method_10566("enchantments", (class_2520)this.enchantments.writeNbt());
        nbt.method_10582("state", this.state.getId());
        nbt.method_10566("fluid", (class_2520)this.fluid.toNbt());
        nbt.method_10544("fluidAmount", this.fluidAmount);
        nbt.method_10566("stack", (class_2520)this.stack.method_7953(new class_2487()));
        nbt.method_10548("compostLevel", this.compostLevel);
        if (this.recipe != null) {
            nbt.method_10582("recipe", this.recipe.method_8114().toString());
        }
        nbt.method_10548("recipeProgress", this.recipeProgress);
    }

    public void method_11014(class_2487 nbt) {
        this.enchantments.readNbt(nbt.method_10562("enchantments"));
        this.state = BarrelState.byId(nbt.method_10558("state"));
        this.fluid = FluidVariant.fromNbt((class_2487)nbt.method_10562("fluid"));
        this.fluidAmount = nbt.method_10537("fluidAmount");
        this.stack = class_1799.method_7915((class_2487)nbt.method_10562("stack"));
        this.compostLevel = nbt.method_10583("compostLevel");
        this.lazeRecipeId = nbt.method_10545("recipe") ? class_2960.method_12829((String)nbt.method_10558("recipe")) : null;
        this.recipeProgress = nbt.method_10583("recipeProgress");
    }

    public void tick() {
        class_1937 class_19372;
        if (this.isCrafting() && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_11245, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
        }
        if (this.tickCounter <= 0) {
            this.tickCounter = ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().tickRate();
            this.method_5431();
            this.tickRecipe();
        } else {
            --this.tickCounter;
            this.method_5431();
        }
    }

    private void tickRecipe() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.getRecipe() != null) {
            if (!this.getRecipe().canContinue(this.field_11863, this)) {
                this.recipe = null;
                this.recipeProgress = 0.0f;
            }
            int duration = this.getRecipe().getDuration();
            this.recipeProgress += 1.0f / (float)duration * (float)this.getEfficiencyMultiplier();
            if (this.recipeProgress >= 1.0f) {
                this.finishRecipe();
            }
            this.method_5431();
            return;
        }
        switch (this.state) {
            case EMPTY: 
            case FLUID: {
                BarrelRecipe.findTick(this).ifPresent(recipe -> {
                    this.recipe = recipe;
                    if (recipe.getDuration() == 0) {
                        this.finishRecipe();
                    }
                    this.method_5431();
                });
                break;
            }
            case ITEM: {
                break;
            }
            case COMPOST: {
                if (this.compostLevel < 1.0f) break;
                this.recipeProgress = (float)((double)this.recipeProgress + ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().compostRate() * (double)this.getEfficiencyMultiplier());
                if (this.recipeProgress >= 1.0f) {
                    this.finishCompost();
                }
                this.method_5431();
            }
        }
    }

    public void setFluid(FluidVariant fluid, long amount) {
        if (amount == 0L || fluid.isBlank()) {
            this.fluid = FluidVariant.blank();
            this.fluidAmount = 0L;
            this.state = BarrelState.EMPTY;
            this.method_5431();
            return;
        }
        this.fluid = fluid;
        this.fluidAmount = amount;
        this.state = BarrelState.FLUID;
        this.method_5431();
    }

    public void setItem(class_1799 stack) {
        this.setFluid(FluidVariant.blank(), 0L);
        if (stack.method_7960()) {
            this.state = BarrelState.EMPTY;
            this.stack = class_1799.field_8037;
            this.method_5431();
            return;
        }
        this.state = BarrelState.ITEM;
        this.stack = stack.method_7972();
        this.method_5431();
    }

    public void fillCompost(class_1799 result, float increment) {
        switch (this.state) {
            case EMPTY: {
                this.state = BarrelState.COMPOST;
                this.stack = result;
            }
            case COMPOST: {
                if (!class_1799.method_7973((class_1799)this.stack, (class_1799)result)) {
                    throw new IllegalStateException("Tired to compost incompatible item");
                }
                this.compostLevel += increment;
                break;
            }
            default: {
                throw new IllegalStateException("Can't compost in state: " + this.state);
            }
        }
        this.method_5431();
    }

    public FluidVariant getFluid() {
        return this.fluid;
    }

    public long getFluidAmount() {
        return this.fluidAmount;
    }

    public class_1799 getItem() {
        return this.stack;
    }

    public BarrelState getState() {
        return this.state;
    }

    public boolean isCrafting() {
        return this.getRecipe() != null;
    }

    void beginRecipe(BarrelRecipe recipe) {
        this.recipe = recipe;
    }

    private void finishRecipe() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        this.getRecipe().apply(serverWorld, this);
        this.recipe = null;
        this.recipeProgress = 0.0f;
    }

    private void finishCompost() {
        this.state = BarrelState.ITEM;
        this.compostLevel = 0.0f;
        this.recipeProgress = 0.0f;
    }

    private BarrelRecipe getRecipe() {
        if (this.lazeRecipeId != null && this.field_11863 != null) {
            BarrelRecipe barrelRecipe;
            Object var2_1 = this.field_11863.method_8433().method_8130(this.lazeRecipeId).orElse(null);
            this.recipe = var2_1 instanceof BarrelRecipe ? (barrelRecipe = (BarrelRecipe)var2_1) : null;
            this.lazeRecipeId = null;
        }
        return this.recipe;
    }

    public float getRecipeProgress() {
        return this.recipeProgress;
    }

    public float getCompostLevel() {
        return this.compostLevel;
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((barrel, direction) -> barrel.itemStorage, TYPE);
        FluidStorage.SIDED.registerForBlockEntity((barrel, direction) -> barrel.fluidStorage, TYPE);
    }

    public class Snapshot {
        private final BarrelState state;
        private final FluidVariant fluid;
        private final long fluidAmount;
        private final class_1799 stack;
        private final float compostLevel;
        private final BarrelRecipe recipe;
        private final float recipeProgress;

        public Snapshot() {
            this.state = BarrelBlockEntity.this.state;
            this.fluid = BarrelBlockEntity.this.fluid;
            this.fluidAmount = BarrelBlockEntity.this.fluidAmount;
            this.stack = BarrelBlockEntity.this.stack;
            this.compostLevel = BarrelBlockEntity.this.compostLevel;
            this.recipeProgress = BarrelBlockEntity.this.recipeProgress;
            this.recipe = BarrelBlockEntity.this.getRecipe();
        }

        public void apply() {
            BarrelBlockEntity.this.state = this.state;
            BarrelBlockEntity.this.fluid = this.fluid;
            BarrelBlockEntity.this.fluidAmount = this.fluidAmount;
            BarrelBlockEntity.this.stack = this.stack;
            BarrelBlockEntity.this.compostLevel = this.compostLevel;
            BarrelBlockEntity.this.recipeProgress = this.recipeProgress;
            BarrelBlockEntity.this.recipe = this.recipe;
        }
    }
}

