/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.sieves;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.base.BaseBlockEntity;
import wraith.fabricaeexnihilo.modules.sieves.SieveBlock;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.SieveRecipe;
import wraith.fabricaeexnihilo.recipe.util.Loot;
import wraith.fabricaeexnihilo.util.ItemUtils;

public class SieveBlockEntity
extends BaseBlockEntity {
    public static final class_2591<SieveBlockEntity> TYPE = FabricBlockEntityTypeBuilder.create(SieveBlockEntity::new, (class_2248[])ModBlocks.SIEVES.values().toArray(new SieveBlock[0])).build(null);
    public static final class_2960 BLOCK_ENTITY_ID = FabricaeExNihilo.id("sieve");
    double progress = 0.0;
    private class_1799 contents = class_1799.field_8037;
    private class_1799 mesh = class_1799.field_8037;

    public SieveBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
    }

    public class_1269 activate(class_2680 state, class_1657 player, class_1268 hand) {
        if (this.field_11863 == null || player == null) {
            return class_1269.field_5811;
        }
        class_1799 held = player.method_5998(hand == null ? player.method_6058() : hand);
        if (held == null) {
            held = class_1799.field_8037;
        }
        if (held.method_7909() instanceof class_1755) {
            return class_1269.field_5811;
        }
        List<SieveBlockEntity> sieves = this.getConnectedSieves();
        if (!this.contents.method_7960()) {
            sieves.forEach(sieve -> sieve.doProgress(player));
            return class_1269.field_5812;
        }
        class_1792 item = held.method_7909();
        if (!this.mesh.method_7960() && player.method_5998(hand).method_7960() && player.method_5715()) {
            player.method_31548().method_7398(this.mesh.method_7972());
            this.mesh = class_1799.field_8037;
            this.method_5431();
            return class_1269.field_5812;
        }
        if (this.mesh.method_7960() && this.isValidMesh(item)) {
            this.mesh = ItemUtils.ofSize(held, 1);
            if (!player.method_7337()) {
                held.method_7934(1);
            }
            this.method_5431();
            return class_1269.field_5812;
        }
        if (held.method_7960() || SieveRecipe.find(held.method_7909(), (Boolean)state.method_11654((class_2769)SieveBlock.WATERLOGGED), class_7923.field_41178.method_10221((Object)this.mesh.method_7909()), this.field_11863).isEmpty()) {
            return class_1269.field_5811;
        }
        class_1799 finalHeld = held;
        sieves.forEach(sieve -> sieve.setContents(finalHeld, !player.method_7337()));
        return class_1269.field_5812;
    }

    private boolean isValidMesh(class_1792 item) {
        assert (this.field_11863 != null);
        return this.field_11863.method_8433().method_30027(ModRecipes.SIEVE).stream().anyMatch(recipe -> recipe.getRolls().containsKey(class_7923.field_41178.method_10221((Object)item)));
    }

    public void doProgress(class_1657 player) {
        int efficiency;
        if (this.field_11863 == null) {
            return;
        }
        class_1293 haste = (class_1293)player.method_6088().get(class_1294.field_5917);
        int n = efficiency = ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).sieves().efficiency() ? class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)this.mesh) : 0;
        int hasteLevel = ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).sieves().haste() ? (haste == null ? -1 : haste.method_5578()) + 1 : 0;
        this.progress += ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).sieves().baseProgress() + ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).sieves().efficiencyScaleFactor() * (double)efficiency + ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).sieves().hasteScaleFactor() * (double)hasteLevel;
        if (this.progress > 1.0) {
            for (Loot result : SieveRecipe.find(this.contents.method_7909(), (Boolean)this.method_11010().method_11654((class_2769)SieveBlock.WATERLOGGED), class_7923.field_41178.method_10221((Object)this.mesh.method_7909()), this.field_11863)) {
                class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260(), (class_1799)result.createStack(this.field_11863.field_9229));
            }
            this.progress = 0.0;
            this.contents = class_1799.field_8037;
        }
        this.method_5431();
    }

    public void dropInventory() {
        Objects.requireNonNull(this.field_11863, "world");
        class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260(), (class_1799)this.mesh);
        class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260(), (class_1799)this.contents);
        this.mesh = class_1799.field_8037;
        this.contents = class_1799.field_8037;
    }

    public List<SieveBlockEntity> getConnectedSieves() {
        ArrayList<SieveBlockEntity> sieves = new ArrayList<SieveBlockEntity>();
        if (this.field_11863 == null) {
            return sieves;
        }
        HashSet<class_2338> tested = new HashSet<class_2338>();
        Stack<class_2338> stack = new Stack<class_2338>();
        stack.add(this.field_11867);
        while (!stack.empty()) {
            class_2586 class_25862;
            class_2338 popped = (class_2338)stack.pop();
            tested.add(popped);
            if (!this.matchingSieveAt(this.field_11863, popped) || !((class_25862 = this.field_11863.method_8321(popped)) instanceof SieveBlockEntity)) continue;
            SieveBlockEntity sieve = (SieveBlockEntity)class_25862;
            sieves.add(sieve);
            Arrays.stream(class_2350.values()).filter(dir -> dir.method_10166().method_10179()).map(arg_0 -> ((class_2338)popped).method_10093(arg_0)).filter(dir -> !tested.contains(dir) && !stack.contains(dir)).filter(dir -> Math.abs(this.field_11867.method_10263() - dir.method_10263()) <= ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).sieves().sieveRadius() && Math.abs(this.field_11867.method_10260() - dir.method_10260()) <= ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).sieves().sieveRadius()).forEach(stack::add);
        }
        return sieves;
    }

    public class_1799 getContents() {
        return this.contents;
    }

    @Nullable
    public class_3611 getFluid() {
        if (this.field_11863 == null) {
            return null;
        }
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if (state == null) {
            return null;
        }
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            return class_3612.field_15906;
        }
        return state.method_26227().method_15772();
    }

    public class_1799 getMesh() {
        return this.mesh;
    }

    public double getProgress() {
        return this.progress;
    }

    private boolean matchingSieveAt(@Nullable class_1937 world, class_2338 pos) {
        if (world == null) {
            return false;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof SieveBlockEntity) {
            SieveBlockEntity sieve = (SieveBlockEntity)class_25862;
            return class_1799.method_7984((class_1799)this.mesh, (class_1799)sieve.mesh) && world.method_8316(pos).method_15772() == this.getFluid();
        }
        return false;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt == null) {
            FabricaeExNihilo.LOGGER.warn("A sieve at " + this.field_11867 + " is missing data.");
            return;
        }
        this.readNbtWithoutWorldInfo(nbt);
    }

    public void readNbtWithoutWorldInfo(class_2487 nbt) {
        this.mesh = class_1799.method_7915((class_2487)nbt.method_10562("mesh"));
        this.contents = class_1799.method_7915((class_2487)nbt.method_10562("contents"));
        this.progress = nbt.method_10574("progress");
    }

    public void setContents(class_1799 stack, boolean doDrain) {
        if (stack.method_7960() || !this.contents.method_7960()) {
            return;
        }
        this.contents = ItemUtils.ofSize(stack, 1);
        if (doDrain) {
            stack.method_7934(1);
        }
        this.progress = 0.0;
        this.method_5431();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.writeNbtWithoutWorldInfo(nbt);
    }

    public void writeNbtWithoutWorldInfo(class_2487 nbt) {
        nbt.method_10566("mesh", (class_2520)this.mesh.method_7953(new class_2487()));
        nbt.method_10566("contents", (class_2520)this.contents.method_7953(new class_2487()));
        nbt.method_10549("progress", this.progress);
    }
}

