/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.recipe.util.Loot;
import wraith.fabricaeexnihilo.util.CodecUtils;

public class SieveRecipe
extends BaseRecipe<Context> {
    private final class_1799 result;
    private final class_1856 input;
    private final boolean waterlogged;
    private final Map<class_2960, ? extends List<Double>> rolls;

    public SieveRecipe(class_2960 id, class_1799 result, class_1856 input, boolean waterlogged, Map<class_2960, ? extends List<Double>> rolls) {
        super(id);
        this.result = result;
        this.input = input;
        this.waterlogged = waterlogged;
        this.rolls = rolls;
    }

    public static List<Loot> find(class_1792 item, boolean waterlogged, class_2960 mesh, @Nullable class_1937 world) {
        if (world == null) {
            return List.of();
        }
        return world.method_8433().method_17877(ModRecipes.SIEVE, (class_1263)new Context(item, waterlogged), world).stream().map(recipe -> new Loot(recipe.result, recipe.rolls.get(mesh))).filter(loot -> loot.chances() != null).toList();
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.input.method_8093(context.input.method_7854()) && this.waterlogged == context.waterlogged;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.SIEVE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.SIEVE;
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.result;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public Map<class_2960, ? extends List<Double>> getRolls() {
        return this.rolls;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    public record Context(class_1792 input, boolean waterlogged) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<SieveRecipe> {
        public SieveRecipe read(class_2960 id, JsonObject json) {
            class_1799 result = CodecUtils.fromJson(CodecUtils.ITEM_STACK, class_3518.method_52226((JsonObject)json, (String)"result"));
            class_1856 input = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)json, (String)"input"));
            boolean waterlogged = class_3518.method_15258((JsonObject)json, (String)"waterlogged", (boolean)false);
            HashMap rolls = new HashMap();
            class_3518.method_15296((JsonObject)json, (String)"rolls").entrySet().forEach(entry -> {
                String meshJson = (String)entry.getKey();
                JsonElement chancesJson = (JsonElement)entry.getValue();
                rolls.put(new class_2960(meshJson), StreamSupport.stream(chancesJson.getAsJsonArray().spliterator(), false).map(JsonElement::getAsDouble).toList());
            });
            return new SieveRecipe(id, result, input, waterlogged, rolls);
        }

        public SieveRecipe read(class_2960 id, class_2540 buf) {
            class_1799 result = buf.method_10819();
            class_1856 input = class_1856.method_8086((class_2540)buf);
            boolean waterlogged = buf.readBoolean();
            Map rolls = buf.method_34067(class_2540::method_10810, buf1 -> (ArrayList)buf1.method_34068(ArrayList::new, class_2540::readDouble));
            return new SieveRecipe(id, result, input, waterlogged, rolls);
        }

        public void write(class_2540 buf, SieveRecipe recipe) {
            buf.method_10793(recipe.result);
            recipe.input.method_8088(buf);
            buf.writeBoolean(recipe.waterlogged);
            buf.method_34063(recipe.rolls, class_2540::method_10812, (buf1, key) -> buf1.method_34062((Collection)key, class_2540::writeDouble));
        }
    }
}

