/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.barrel;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelState;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipe;
import wraith.fabricaeexnihilo.recipe.util.BlockIngredient;
import wraith.fabricaeexnihilo.recipe.util.EntityStack;
import wraith.fabricaeexnihilo.recipe.util.FluidIngredient;
import wraith.fabricaeexnihilo.util.CodecUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BarrelRecipeAction {
    default public boolean canRun(BarrelRecipe recipe, BarrelBlockEntity barrel) {
        return true;
    }

    public void apply(class_3218 var1, BarrelBlockEntity var2);

    default public void toPacket(class_2540 buf) {
        buf.writeByte((int)this.getId());
        this.writePacket(buf);
    }

    default public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getName());
        this.writeJson(json);
        return json;
    }

    public void writePacket(class_2540 var1);

    public void writeJson(JsonObject var1);

    public byte getId();

    public String getName();

    public static BarrelRecipeAction fromJson(JsonObject json) {
        String type;
        return switch (type = class_3518.method_15265((JsonObject)json, (String)"type")) {
            case "spawn_entity" -> new SpawnEntity(json);
            case "store_item" -> new StoreItem(json);
            case "store_fluid" -> new StoreFluid(json);
            case "consume_fluid" -> new ConsumeFluid(json);
            case "convert_block" -> new ConvertBlock(json);
            case "drop_item" -> new DropItem(json);
            case "fill_compost" -> new FillCompost(json);
            default -> throw new JsonParseException("Unknown action type: " + type);
        };
    }

    public static BarrelRecipeAction fromPacket(class_2540 buf) {
        byte type = buf.readByte();
        return switch (type) {
            case 0 -> new SpawnEntity(CodecUtils.fromPacket(EntityStack.CODEC, buf));
            case 1 -> new StoreItem(buf.method_10819());
            case 2 -> new StoreFluid(FluidVariant.fromPacket((class_2540)buf), buf.method_10792());
            case 3 -> new ConsumeFluid(FluidIngredient.fromPacket(buf), buf.method_10792());
            case 4 -> new ConvertBlock(BlockIngredient.fromPacket(buf), (class_2680)CodecUtils.fromPacket(class_2680.field_24734, buf));
            case 5 -> new DropItem(buf.method_10819());
            case 6 -> new FillCompost(buf);
            default -> throw new JsonParseException("Unknown action type id: " + type);
        };
    }

    public record SpawnEntity(EntityStack entities) implements BarrelRecipeAction
    {
        private static final String NAME = "spawn_entity";
        private static final byte ID = 0;

        public SpawnEntity(JsonObject json) {
            this(CodecUtils.fromJson(EntityStack.CODEC, class_3518.method_52226((JsonObject)json, (String)"entities")));
        }

        @Override
        public void apply(class_3218 world, BarrelBlockEntity barrel) {
            class_2338 pos = barrel.method_11016().method_10084();
            for (int i = 0; i < this.entities.getSize(); ++i) {
                class_1297 entity = this.entities.getEntity(world, pos);
                if (entity == null) continue;
                world.method_8649(entity);
            }
        }

        @Override
        public void writePacket(class_2540 buf) {
            CodecUtils.toPacket(EntityStack.CODEC, this.entities, buf);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("entities", CodecUtils.toJson(EntityStack.CODEC, this.entities));
        }

        @Override
        public byte getId() {
            return 0;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record StoreItem(class_1799 stack) implements BarrelRecipeAction
    {
        private static final String NAME = "store_item";
        private static final byte ID = 1;

        public StoreItem(JsonObject json) {
            this(CodecUtils.fromJson(CodecUtils.ITEM_STACK, class_3518.method_52226((JsonObject)json, (String)"stack")));
        }

        @Override
        public void apply(class_3218 world, BarrelBlockEntity barrel) {
            barrel.setItem(this.stack);
        }

        @Override
        public void writePacket(class_2540 buf) {
            buf.method_10793(this.stack);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("stack", CodecUtils.toJson(CodecUtils.ITEM_STACK, this.stack));
        }

        @Override
        public byte getId() {
            return 1;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record StoreFluid(FluidVariant fluid, long amount) implements BarrelRecipeAction
    {
        private static final String NAME = "store_fluid";
        private static final byte ID = 2;

        public StoreFluid(JsonObject json) {
            this(CodecUtils.fromJson(CodecUtils.FLUID_VARIANT, class_3518.method_52226((JsonObject)json, (String)"fluid")), class_3518.method_15280((JsonObject)json, (String)"amount", (long)81000L));
        }

        @Override
        public void apply(class_3218 world, BarrelBlockEntity barrel) {
            barrel.setFluid(this.fluid, this.amount);
        }

        @Override
        public void writePacket(class_2540 buf) {
            this.fluid.toPacket(buf);
            buf.method_10791(this.amount);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("fluid", CodecUtils.toJson(CodecUtils.FLUID_VARIANT, this.fluid));
            json.addProperty("amount", (Number)this.amount);
        }

        @Override
        public byte getId() {
            return 2;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record ConsumeFluid(FluidIngredient fluid, long amount) implements BarrelRecipeAction
    {
        private static final String NAME = "consume_fluid";
        private static final byte ID = 3;

        public ConsumeFluid(JsonObject json) {
            this(FluidIngredient.fromJson(class_3518.method_52226((JsonObject)json, (String)"fluid")), class_3518.method_15280((JsonObject)json, (String)"amount", (long)81000L));
        }

        @Override
        public boolean canRun(BarrelRecipe recipe, BarrelBlockEntity barrel) {
            return this.fluid.test(barrel.getFluid().getFluid()) && barrel.getFluidAmount() >= this.amount;
        }

        @Override
        public void apply(class_3218 world, BarrelBlockEntity barrel) {
            barrel.setFluid(barrel.getFluid(), barrel.getFluidAmount() - this.amount);
        }

        @Override
        public void writePacket(class_2540 buf) {
            this.fluid.toPacket(buf);
            buf.method_10791(this.amount);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("fluid", this.fluid.toJson());
            json.addProperty("amount", (Number)this.amount);
        }

        @Override
        public byte getId() {
            return 3;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record ConvertBlock(BlockIngredient filter, class_2680 result) implements BarrelRecipeAction
    {
        private static final String NAME = "convert_block";
        private static final byte ID = 4;

        public ConvertBlock(JsonObject json) {
            this(BlockIngredient.fromJson(class_3518.method_52226((JsonObject)json, (String)"filter")), (class_2680)CodecUtils.fromJson(class_2680.field_24734, class_3518.method_52226((JsonObject)json, (String)"result")));
        }

        @Override
        public boolean canRun(BarrelRecipe recipe, BarrelBlockEntity barrel) {
            class_1937 world = Objects.requireNonNull(barrel.method_10997(), "world is null");
            class_2338 pos = barrel.method_11016();
            int radius = ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().leakRadius();
            return class_2338.method_20437((class_2338)pos.method_10069(-radius, 0, -radius), (class_2338)pos.method_10069(radius, -2, radius)).map(arg_0 -> ((class_1937)world).method_8320(arg_0)).anyMatch(this.filter);
        }

        @Override
        public void apply(class_3218 world, BarrelBlockEntity barrel) {
            class_2338 pos = barrel.method_11016();
            int radius = ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().leakRadius();
            List<class_2338> positions = class_2338.method_20437((class_2338)pos.method_10069(-radius, 0, -radius), (class_2338)pos.method_10069(radius, -2, radius)).map(class_2338::method_10062).filter(candidate -> this.filter.test(world.method_8320(candidate))).toList();
            class_2338 chosen = positions.get(world.field_9229.method_43048(positions.size()));
            world.method_8652(chosen, this.result, 2);
        }

        @Override
        public void writePacket(class_2540 buf) {
            this.filter.toPacket(buf);
            CodecUtils.toPacket(class_2680.field_24734, this.result, buf);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("filter", this.filter.toJson());
            json.add("result", CodecUtils.toJson(class_2680.field_24734, this.result));
        }

        @Override
        public byte getId() {
            return 4;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record DropItem(class_1799 stack) implements BarrelRecipeAction
    {
        private static final String NAME = "drop_item";
        private static final byte ID = 5;

        public DropItem(JsonObject json) {
            this(CodecUtils.fromJson(CodecUtils.ITEM_STACK, class_3518.method_52226((JsonObject)json, (String)"stack")));
        }

        @Override
        public void apply(class_3218 world, BarrelBlockEntity barrel) {
            class_243 pos = class_243.method_24955((class_2382)barrel.method_11016().method_10084());
            class_1264.method_5449((class_1937)world, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)this.stack.method_7972());
        }

        @Override
        public void writePacket(class_2540 buf) {
            buf.method_10793(this.stack);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("stack", CodecUtils.toJson(CodecUtils.ITEM_STACK, this.stack));
        }

        @Override
        public byte getId() {
            return 5;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record FillCompost(class_1799 result, float increment) implements BarrelRecipeAction
    {
        private static final String NAME = "fill_compost";
        private static final byte ID = 6;

        public FillCompost(JsonObject json) {
            this(CodecUtils.fromJson(CodecUtils.ITEM_STACK, class_3518.method_52226((JsonObject)json, (String)"result")), class_3518.method_15259((JsonObject)json, (String)"increment"));
        }

        public FillCompost(class_2540 buf) {
            this(buf.method_10819(), buf.readFloat());
        }

        @Override
        public boolean canRun(BarrelRecipe recipe, BarrelBlockEntity barrel) {
            return barrel.getState() == BarrelState.EMPTY || barrel.getState() == BarrelState.COMPOST && class_1799.method_7973((class_1799)barrel.getItem(), (class_1799)this.result);
        }

        @Override
        public void apply(class_3218 world, BarrelBlockEntity barrel) {
            barrel.fillCompost(this.result, this.increment);
        }

        @Override
        public void writePacket(class_2540 buf) {
            buf.method_10793(this.result);
            buf.writeFloat(this.increment);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("result", CodecUtils.toJson(CodecUtils.ITEM_STACK, this.result));
            json.addProperty("increment", (Number)Float.valueOf(this.increment));
        }

        @Override
        public byte getId() {
            return 6;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

