/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.barrel;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelState;
import wraith.fabricaeexnihilo.recipe.util.BlockIngredient;
import wraith.fabricaeexnihilo.recipe.util.FluidIngredient;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BarrelRecipeCondition {
    public boolean check(class_1937 var1, BarrelBlockEntity var2);

    default public void toPacket(class_2540 buf) {
        buf.writeByte((int)this.getId());
        this.writePacket(buf);
    }

    default public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getName());
        this.writeJson(json);
        return json;
    }

    public void writePacket(class_2540 var1);

    public void writeJson(JsonObject var1);

    public byte getId();

    public String getName();

    public static BarrelRecipeCondition fromJson(JsonObject json) {
        String type;
        return switch (type = class_3518.method_15265((JsonObject)json, (String)"type")) {
            case "fluid_above" -> new FluidAbove(json);
            case "block_above" -> new BlockAbove(json);
            case "block_below" -> new BlockBelow(json);
            case "fluid_in" -> new FluidIn(json);
            default -> throw new JsonParseException("Unknown condition type: " + type);
        };
    }

    public static BarrelRecipeCondition fromPacket(class_2540 buf) {
        byte type = buf.readByte();
        return switch (type) {
            case 0 -> new FluidAbove(buf);
            case 1 -> new BlockAbove(buf);
            case 2 -> new BlockBelow(buf);
            case 3 -> new FluidIn(buf);
            default -> throw new JsonParseException("Unknown condition type id: " + type);
        };
    }

    public record FluidAbove(FluidIngredient fluid) implements BarrelRecipeCondition
    {
        private static final String NAME = "fluid_above";
        private static final byte ID = 0;

        public FluidAbove(JsonObject json) {
            this(FluidIngredient.fromJson(class_3518.method_52226((JsonObject)json, (String)"fluid")));
        }

        public FluidAbove(class_2540 buf) {
            this(FluidIngredient.fromPacket(buf));
        }

        @Override
        public boolean check(class_1937 world, BarrelBlockEntity barrel) {
            return this.fluid.test(world.method_8316(barrel.method_11016().method_10084()).method_15772());
        }

        @Override
        public void writePacket(class_2540 buf) {
            this.fluid.toPacket(buf);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("fluid", this.fluid.toJson());
        }

        @Override
        public byte getId() {
            return 0;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record BlockAbove(BlockIngredient block) implements BarrelRecipeCondition
    {
        private static final String NAME = "block_above";
        private static final byte ID = 1;

        public BlockAbove(JsonObject json) {
            this(BlockIngredient.fromJson(class_3518.method_52226((JsonObject)json, (String)"block")));
        }

        public BlockAbove(class_2540 buf) {
            this(BlockIngredient.fromPacket(buf));
        }

        @Override
        public boolean check(class_1937 world, BarrelBlockEntity barrel) {
            return this.block.test(world.method_8320(barrel.method_11016().method_10084()));
        }

        @Override
        public void writePacket(class_2540 buf) {
            this.block.toPacket(buf);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("block", this.block.toJson());
        }

        @Override
        public byte getId() {
            return 1;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record BlockBelow(BlockIngredient block) implements BarrelRecipeCondition
    {
        private static final String NAME = "block_below";
        private static final byte ID = 2;

        public BlockBelow(JsonObject json) {
            this(BlockIngredient.fromJson(class_3518.method_52226((JsonObject)json, (String)"block")));
        }

        public BlockBelow(class_2540 buf) {
            this(BlockIngredient.fromPacket(buf));
        }

        @Override
        public boolean check(class_1937 world, BarrelBlockEntity barrel) {
            return this.block.test(world.method_8320(barrel.method_11016().method_10084()));
        }

        @Override
        public void writePacket(class_2540 buf) {
            this.block.toPacket(buf);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("block", this.block.toJson());
        }

        @Override
        public byte getId() {
            return 2;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public record FluidIn(FluidIngredient fluid) implements BarrelRecipeCondition
    {
        private static final String NAME = "fluid_in";
        private static final byte ID = 3;

        public FluidIn(JsonObject json) {
            this(FluidIngredient.fromJson(class_3518.method_52226((JsonObject)json, (String)"fluid")));
        }

        public FluidIn(class_2540 buf) {
            this(FluidIngredient.fromPacket(buf));
        }

        @Override
        public boolean check(class_1937 world, BarrelBlockEntity barrel) {
            if (barrel.getState() != BarrelState.FLUID && barrel.getState() != BarrelState.EMPTY) {
                return false;
            }
            if (!this.fluid.test(barrel.getFluid().getFluid())) {
                return false;
            }
            return barrel.getFluidAmount() >= 81000L;
        }

        @Override
        public void writePacket(class_2540 buf) {
            this.fluid.toPacket(buf);
        }

        @Override
        public void writeJson(JsonObject json) {
            json.add("fluid", this.fluid.toJson());
        }

        @Override
        public byte getId() {
            return 3;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

