/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import java.util.function.Predicate;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class FluidIngredient
implements Predicate<class_3611> {
    public static FluidIngredient fromJson(JsonElement json) {
        String data = class_3518.method_15287((JsonElement)json, (String)"fluid ingredient");
        if (data.startsWith("#")) {
            return new Tag((class_6862<class_3611>)class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)new class_2960(data.substring(1))));
        }
        return new Single((class_3611)class_7923.field_41173.method_10223(new class_2960(data)));
    }

    public static FluidIngredient fromPacket(class_2540 buf) {
        byte id = buf.readByte();
        return switch (id) {
            case 0 -> new Single((class_3611)buf.method_42064((class_2359)class_7923.field_41173));
            case 1 -> new Tag((class_6862<class_3611>)class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)buf.method_10810()));
            default -> throw new IllegalStateException("Unexpected fluid ingredient type: " + id);
        };
    }

    public static FluidIngredient single(class_3611 fluid) {
        return new Single(fluid);
    }

    public static FluidIngredient tag(class_6862<class_3611> tag) {
        return new Tag(tag);
    }

    public abstract Either<class_3611, class_6862<class_3611>> getValue();

    public abstract void toPacket(class_2540 var1);

    public abstract JsonElement toJson();

    public abstract boolean isEmpty();

    private static final class Tag
    extends FluidIngredient {
        private final class_6862<class_3611> tag;

        private Tag(class_6862<class_3611> tag) {
            this.tag = tag;
        }

        @Override
        public boolean test(class_3611 fluid) {
            return fluid.method_15791(this.tag);
        }

        @Override
        public Either<class_3611, class_6862<class_3611>> getValue() {
            return Either.right(this.tag);
        }

        @Override
        public void toPacket(class_2540 buf) {
            buf.writeByte(1);
            buf.method_10812(this.tag.comp_327());
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive("#" + this.tag.comp_327().toString());
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static final class Single
    extends FluidIngredient {
        private final class_3611 fluid;

        private Single(class_3611 fluid) {
            this.fluid = fluid;
        }

        @Override
        public boolean test(class_3611 fluid) {
            return fluid.method_15780(this.fluid);
        }

        @Override
        public Either<class_3611, class_6862<class_3611>> getValue() {
            return Either.left((Object)this.fluid);
        }

        @Override
        public void toPacket(class_2540 buf) {
            buf.writeByte(0);
            buf.method_42065((class_2359)class_7923.field_41173, (Object)this.fluid);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(class_7923.field_41173.method_10221((Object)this.fluid).toString());
        }

        @Override
        public boolean isEmpty() {
            return this.fluid == class_3612.field_15906;
        }
    }
}

