/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.witchwater;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;

public class WitchWaterEntityRecipe
extends BaseRecipe<Context> {
    private final class_1299<?> target;
    private final class_2203.class_2209 nbt;
    private final class_1299<?> result;

    public WitchWaterEntityRecipe(class_2960 id, class_1299<?> target, class_2203.class_2209 nbt, class_1299<?> result) {
        super(id);
        this.target = target;
        this.nbt = nbt;
        this.result = result;
    }

    public static Optional<WitchWaterEntityRecipe> find(class_1297 entity, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.WITCH_WATER_ENTITY, (class_1263)new Context(entity), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        if (this.target != context.entity.method_5864()) {
            return false;
        }
        return this.nbt.method_9374((class_2520)context.entity.method_5647(new class_2487())) > 0;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.WITCH_WATER_ENTITY_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.WITCH_WATER_ENTITY;
    }

    @Override
    public class_1799 getDisplayStack() {
        class_1826 egg = class_1826.method_8019(this.result);
        return egg == null ? class_1799.field_8037 : egg.method_7854();
    }

    public class_1299<?> getTarget() {
        return this.target;
    }

    public class_2203.class_2209 getNbt() {
        return this.nbt;
    }

    public class_1299<?> getResult() {
        return this.result;
    }

    protected record Context(class_1297 entity) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<WitchWaterEntityRecipe> {
        public WitchWaterEntityRecipe read(class_2960 id, JsonObject json) {
            class_1299 target = (class_1299)class_7923.field_41177.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"target")));
            class_1299 result = (class_1299)class_7923.field_41177.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"result")));
            class_2203.class_2209 nbt = Serializer.parseNbtPath(class_3518.method_15253((JsonObject)json, (String)"nbt", (String)"{}"));
            return new WitchWaterEntityRecipe(id, target, nbt, result);
        }

        public WitchWaterEntityRecipe read(class_2960 id, class_2540 buf) {
            class_1299 target = (class_1299)class_7923.field_41177.method_10223(buf.method_10810());
            class_2203.class_2209 nbt = Serializer.parseNbtPath(buf.method_19772());
            class_1299 result = (class_1299)class_7923.field_41177.method_10223(buf.method_10810());
            return new WitchWaterEntityRecipe(id, target, nbt, result);
        }

        public void write(class_2540 buf, WitchWaterEntityRecipe recipe) {
            buf.method_10812(class_7923.field_41177.method_10221(recipe.target));
            buf.method_10814(recipe.nbt.toString());
            buf.method_10812(class_7923.field_41177.method_10221(recipe.result));
        }

        private static class_2203.class_2209 parseNbtPath(String string) {
            class_2203.class_2209 nbt;
            try {
                StringReader reader = new StringReader(string);
                nbt = class_2203.method_9360().method_9362(reader);
                String remaining = reader.getRemaining();
                if (remaining.length() > 0) {
                    throw new IllegalArgumentException("Found trailing data after nbt path: " + remaining);
                }
            }
            catch (CommandSyntaxException e) {
                throw new IllegalStateException("Invalid nbt filter", e);
            }
            return nbt;
        }
    }
}

