/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.screen;

import com.teamresourceful.resourcefullib.client.screens.BaseCursorScreen;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.client.config.RadioConfig;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.client.radio.screen.RadioList;
import earth.terrarium.adastra.client.radio.screen.VolumeButton;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundRequestStationsPacket;
import earth.terrarium.adastra.common.utils.radio.StationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioScreen
extends BaseCursorScreen {
    private static final class_2960 TEXTURE = new class_2960("ad_astra", "textures/radio/ui.png");
    private static final class_2960 CLOCK = new class_2960("ad_astra", "textures/radio/clock.png");
    private static final int WIDTH = 253;
    private static final int HEIGHT = 138;
    private final List<StationInfo> stations = new ArrayList<StationInfo>();
    private final Map<String, String> stationNames = new HashMap<String, String>();
    @Nullable
    private final class_2338 pos;
    private RadioList list;

    public RadioScreen(@Nullable class_2338 pos) {
        super(class_5244.field_39003);
        this.pos = pos;
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundRequestStationsPacket());
    }

    protected void method_25426() {
        int left = (this.field_22789 - 253) / 2;
        int top = (this.field_22790 - 138) / 2;
        this.method_37063((class_364)new VolumeButton(left + 116, top + 83, 21, 21, 1));
        this.method_37063((class_364)new VolumeButton(left + 116, top + 105, 21, 21, -1));
        this.list = (RadioList)this.method_37063((class_364)new RadioList(left + 149, top + 84, this.pos));
        if (!this.stations.isEmpty()) {
            this.list.update(this.stations, RadioHandler.getPlaying());
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(graphics, mouseX, mouseY, partialTick);
        int left = (this.field_22789 - 253) / 2;
        int top = (this.field_22790 - 138) / 2;
        graphics.method_25290(TEXTURE, left, top, 0.0f, 0.0f, 253, 138, 512, 256);
        this.renderClock(graphics, left + 29, top + 92);
        graphics.method_25303(this.field_22793, RadioConfig.volume + "%", left + 102 - this.field_22793.method_1727(RadioConfig.volume + "%"), top + 114, 1610776);
        graphics.method_25303(this.field_22793, "Day " + RadioScreen.getDayTime() / 24000L, left + 16, top + 114, 1610776);
        String playing = RadioHandler.getPlaying();
        if (playing != null && this.stationNames.containsKey(playing.toLowerCase(Locale.ROOT))) {
            RadioScreen.renderScrollingString(graphics, this.field_22793, (class_2561)class_2561.method_43470((String)this.stationNames.get(playing.toLowerCase(Locale.ROOT))), left + 65, top + 37, left + 188, top + 46, 1610776);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    protected static void renderScrollingString(class_332 graphics, class_327 font, class_2561 text, int minX, int minY, int maxX, int maxY, int color) {
        int k;
        int i = font.method_27525((class_5348)text);
        if (i > (k = maxX - minX)) {
            int l = i - k;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
            graphics.method_44379(minX, minY, maxX, maxY);
            graphics.method_27535(font, text, minX - (int)g, (minY + maxY - 9) / 2 + 1, color);
            graphics.method_44380();
        } else {
            graphics.method_27534(font, text, (minX + maxX) / 2, (minY + maxY - 9) / 2 + 1, color);
        }
    }

    public void renderClock(class_332 graphics, int x, int y) {
        double ratio = 16.666666666666668;
        int dayTime = (int)((RadioScreen.getDayTime() + 6000L) % 12000L);
        boolean isPm = (int)((RadioScreen.getDayTime() + 6000L) % 24000L) >= 12000;
        int hours = dayTime / 1000 == 0 ? 12 : dayTime / 1000;
        int minutes = (int)((double)(dayTime % 1000) / ratio);
        int firstHour = hours / 10;
        int secondHour = hours % 10;
        int firstMinute = minutes / 10;
        int secondMinute = minutes % 10;
        graphics.method_25290(CLOCK, x, y, 0.0f, (float)(firstHour % 5 * 13), 8, 13, 64, 64);
        graphics.method_25290(CLOCK, x + 8, y, (float)((int)((float)secondHour / 5.0f) * 8), (float)(secondHour % 5 * 13), 8, 13, 64, 64);
        graphics.method_25290(CLOCK, x + 16, y, 39.0f, 0.0f, 5, 13, 64, 64);
        graphics.method_25290(CLOCK, x + 21, y, (float)((int)((float)firstMinute / 5.0f) * 8), (float)(firstMinute % 5 * 13), 8, 13, 64, 64);
        graphics.method_25290(CLOCK, x + 29, y, (float)((int)((float)secondMinute / 5.0f) * 8), (float)(secondMinute % 5 * 13), 8, 13, 64, 64);
        graphics.method_25290(CLOCK, x + 37, y, 42.0f, isPm ? 0.0f : 13.0f, 22, 13, 64, 64);
    }

    private static long getDayTime() {
        if (class_310.method_1551().field_1687 == null) {
            return 0L;
        }
        return class_310.method_1551().field_1687.method_8532();
    }

    public boolean method_25421() {
        return false;
    }

    public static void handleStationUpdates(List<StationInfo> stations) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof RadioScreen) {
            RadioScreen screen = (RadioScreen)class_4372;
            screen.list.update(stations, RadioHandler.getPlaying());
            screen.stations.clear();
            screen.stationNames.clear();
            for (StationInfo station : stations) {
                screen.stationNames.put(station.url().toLowerCase(Locale.ROOT), station.name());
                screen.stations.add(station);
            }
        }
    }
}

