/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.blockentities.base.MachineBlockEntity;
import earth.terrarium.adastra.common.blocks.machines.DetectorBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class DetectorBlockEntity
extends MachineBlockEntity {
    public DetectorBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state);
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        boolean power;
        if (time % 40L != 0L) {
            return;
        }
        boolean inverted = (Boolean)state.method_11654((class_2769)DetectorBlock.INVERTED);
        switch ((DetectorBlock.DetectionType)((Object)state.method_11654(DetectorBlock.DETECTION_TYPE))) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OXYGEN: {
                boolean bl = this.hasOxygen(level, pos, inverted);
                break;
            }
            case GRAVITY: {
                boolean bl = this.hasNormalGravity(level, pos, inverted);
                break;
            }
            case TEMPERATURE: {
                boolean bl = power = this.hasSafeTemperature(level, pos, inverted);
            }
        }
        if (power != (Boolean)state.method_11654((class_2769)DetectorBlock.POWERED)) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)DetectorBlock.POWERED, (Comparable)Boolean.valueOf(power)));
        }
    }

    public boolean hasOxygen(class_3218 level, class_2338 pos, boolean inverted) {
        for (class_2350 direction : class_2350.values()) {
            if (!OxygenApi.API.hasOxygen((class_1937)level, pos.method_10093(direction))) continue;
            return !inverted;
        }
        return inverted;
    }

    public boolean hasNormalGravity(class_3218 level, class_2338 pos, boolean inverted) {
        for (class_2350 direction : class_2350.values()) {
            float gravity = GravityApi.API.getGravity((class_1937)level, pos.method_10093(direction)) * 9.807f;
            if (!(gravity > 8.807f) || !(gravity < 10.807f)) continue;
            return !inverted;
        }
        return inverted;
    }

    public boolean hasSafeTemperature(class_3218 level, class_2338 pos, boolean inverted) {
        for (class_2350 direction : class_2350.values()) {
            if (!TemperatureApi.API.isLiveable((class_1937)level, pos.method_10093(direction))) continue;
            return !inverted;
        }
        return inverted;
    }
}

