/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items.armor;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.items.armor.base.CustomDyeableArmorItem;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.tags.ModItemTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpaceSuitItem
extends CustomDyeableArmorItem
implements BotariumFluidItem<WrappedItemFluidContainer> {
    protected final long tankSize;

    public SpaceSuitItem(class_1741 material, class_1738.class_8051 type, long tankSize, class_1792.class_1793 properties) {
        super(material, type, properties);
        this.tankSize = tankSize;
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidConstants.fromMillibuckets((long)this.tankSize), (class_3611)ModFluids.OXYGEN.get()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.SPACE_SUIT_INFO);
    }

    public WrappedItemFluidContainer getFluidContainer(class_1799 holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)this.tankSize), 1, (t, f) -> f.is(ModFluidTags.OXYGEN)));
    }

    public static boolean hasFullSet(class_1309 entity) {
        return SpaceSuitItem.hasFullSet(entity, ModItemTags.SPACE_SUITS);
    }

    public static boolean hasFullNetheriteSet(class_1309 entity) {
        return SpaceSuitItem.hasFullSet(entity, ModItemTags.NETHERITE_SPACE_SUITS);
    }

    public static boolean hasFullJetSuitSet(class_1309 entity) {
        return SpaceSuitItem.hasFullSet(entity, ModItemTags.JET_SUITS);
    }

    public static boolean hasFullSet(class_1309 entity, class_6862<class_1792> spaceSuitTag) {
        return StreamSupport.stream(entity.method_5661().spliterator(), false).allMatch(stack -> stack.method_31573(spaceSuitTag));
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        class_1657 player;
        super.method_7888(stack, level, entity, slotId, isSelected);
        if (level.method_8608()) {
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        if (livingEntity instanceof class_1657 && ((player = (class_1657)livingEntity).method_7337() || player.method_7325())) {
            return;
        }
        if (livingEntity.method_6118(class_1304.field_6174) != stack) {
            return;
        }
        livingEntity.method_32317(0);
        if (livingEntity.field_6012 % 12 == 0 && SpaceSuitItem.hasOxygen(entity)) {
            if (!OxygenApi.API.hasOxygen(entity)) {
                this.consumeOxygen(stack, 1L);
            }
            if (entity.method_5777(class_3486.field_15517)) {
                this.consumeOxygen(stack, 1L);
                livingEntity.method_5855(Math.min(livingEntity.method_5748(), livingEntity.method_5669() + 40));
            }
        }
    }

    public void consumeOxygen(class_1799 stack, long amount) {
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)holder);
        if (container == null) {
            return;
        }
        FluidHolder extracted = container.extractFluid(container.getFirstFluid().copyWithAmount(FluidConstants.fromMillibuckets((long)amount)), false);
        if (holder.isDirty() || extracted.getFluidAmount() > 0L) {
            stack.method_7980(holder.getStack().method_7969());
        }
    }

    public static long getOxygenAmount(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return 0L;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1799 stack = livingEntity.method_6118(class_1304.field_6174);
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SpaceSuitItem)) {
            return 0L;
        }
        SpaceSuitItem suit = (SpaceSuitItem)class_17922;
        return suit.getFluidContainer(stack).getFirstFluid().getFluidAmount();
    }

    public static boolean hasOxygen(class_1297 entity) {
        return SpaceSuitItem.getOxygenAmount(entity) > FluidConstants.fromMillibuckets((long)1L);
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return FluidUtils.hasFluid(stack);
    }

    public int method_31569(@NotNull class_1799 stack) {
        WrappedItemFluidContainer fluidContainer = this.getFluidContainer(stack);
        return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
    }

    public int method_31571(@NotNull class_1799 stack) {
        return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank(stack));
    }
}

