/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipe;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipeSerializer;
import earth.terrarium.adastra.common.recipes.base.IngredientHolder;
import earth.terrarium.adastra.common.registry.ModRecipeSerializers;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

public record SpaceStationRecipe(List<IngredientHolder> ingredients, class_5321<class_1937> dimension, class_2960 structure) implements CodecRecipe<class_1263>
{
    public static final Codec<SpaceStationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientHolder.CODEC.listOf().fieldOf("ingredients").forGetter(SpaceStationRecipe::ingredients), (App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("dimension").forGetter(SpaceStationRecipe::dimension), (App)class_2960.field_25139.fieldOf("structure").forGetter(SpaceStationRecipe::structure)).apply((Applicative)instance, SpaceStationRecipe::new));
    public static final ByteCodec<SpaceStationRecipe> NETWORK_CODEC = ObjectByteCodec.create((ObjectEntryByteCodec)IngredientHolder.NETWORK_CODEC.listOf().fieldOf(SpaceStationRecipe::ingredients), (ObjectEntryByteCodec)ExtraByteCodecs.resourceKey((class_5321)class_7924.field_41223).fieldOf(SpaceStationRecipe::dimension), (ObjectEntryByteCodec)ExtraByteCodecs.RESOURCE_LOCATION.fieldOf(SpaceStationRecipe::structure), SpaceStationRecipe::new);

    public boolean method_8115(@NotNull class_1263 container, @NotNull class_1937 level) {
        for (IngredientHolder holder : this.ingredients) {
            int count = 0;
            for (int i = 0; i < container.method_5439(); ++i) {
                class_1799 stack = container.method_5438(i);
                if (!holder.ingredient().method_8093(stack)) continue;
                count += stack.method_7947();
            }
            if (count >= holder.count()) continue;
            return false;
        }
        return true;
    }

    public CodecRecipeSerializer<? extends CodecRecipe<class_1263>> serializer() {
        return (CodecRecipeSerializer)ModRecipeSerializers.SPACE_STATION_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)ModRecipeTypes.SPACE_STATION_RECIPE.get();
    }

    public static Optional<class_8786<SpaceStationRecipe>> getSpaceStation(class_1937 level, class_5321<class_1937> dimension) {
        return level.method_8433().method_30027((class_3956)ModRecipeTypes.SPACE_STATION_RECIPE.get()).stream().filter(r -> dimension.equals(((SpaceStationRecipe)r.comp_1933()).dimension())).findFirst();
    }

    public static boolean hasIngredients(class_1657 player, class_1937 level, SpaceStationRecipe recipe) {
        if (player.method_7337() || player.method_7325()) {
            return true;
        }
        return recipe.method_8115((class_1263)player.method_31548(), level);
    }

    public static void consumeIngredients(class_1657 player, class_1937 level) {
        if (player.method_7337() || player.method_7325()) {
            return;
        }
        class_8786 recipe = level.method_8433().method_30027((class_3956)ModRecipeTypes.SPACE_STATION_RECIPE.get()).stream().filter(r -> level.method_27983().equals(((SpaceStationRecipe)r.comp_1933()).dimension())).findFirst().orElse(null);
        if (recipe == null) {
            return;
        }
        if (!((SpaceStationRecipe)recipe.comp_1933()).method_8115((class_1263)player.method_31548(), level)) {
            return;
        }
        class_1661 inventory = player.method_31548();
        block0: for (IngredientHolder holder : ((SpaceStationRecipe)recipe.comp_1933()).ingredients()) {
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (!holder.ingredient().method_8093(inventory.method_5438(i))) continue;
                inventory.method_5434(i, holder.count());
                continue block0;
            }
        }
    }
}

