/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.ChargeMode;
import ad_astra_giselle_addon.common.content.oxygen.IChargeMode;
import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IOxygenCharger {
    default public List<IChargeMode> getAvailableChargeModes() {
        return Arrays.asList(ChargeMode.values());
    }

    @NotNull
    public IChargeMode getChargeMode();

    public void setChargeMode(@Nullable IChargeMode var1);

    public long getTransferAmount();

    public FluidContainer getFluidContainer();

    public boolean canUseOnCold();

    public boolean canUseOnHot();

    default public boolean canUse(boolean isCold, boolean isHot) {
        if (isCold && !this.canUseOnCold()) {
            return false;
        }
        return !isHot || this.canUseOnHot();
    }

    default public long getTotalAmount() {
        return this.getFluidContainer().getFluids().stream().collect(Collectors.summingLong(FluidHolder::getFluidAmount));
    }

    default public long getTotalCapacity() {
        FluidContainer fluidContainer = this.getFluidContainer();
        int size = fluidContainer.getSize();
        long capacity = 0L;
        for (int i = 0; i < size; ++i) {
            capacity += fluidContainer.getTankCapacity(i);
        }
        return capacity;
    }

    default public double getStoredRatio() {
        long amount = this.getTotalAmount();
        long capacity = this.getTotalCapacity();
        return FluidUtils2.getStoredRatio(amount, capacity);
    }

    default public void copyFrom(IOxygenCharger from) {
        this.setChargeMode(from.getChargeMode());
        FluidUtils2.moveFluidAny(from.getFluidContainer(), this.getFluidContainer(), f -> true, false);
    }
}

