/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.showmeyourskin.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import nl.enjarai.showmeyourskin.Components;
import nl.enjarai.showmeyourskin.ShowMeYourSkinClient;
import nl.enjarai.showmeyourskin.config.ArmorConfig;
import nl.enjarai.showmeyourskin.config.HideableEquipment;
import nl.enjarai.showmeyourskin.util.ArmorConfigComponent;
import nl.enjarai.showmeyourskin.util.CombatLogger;

public class ModConfig {
    public static final File CONFIG_FILE = new File(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/showmeyourskin.json");
    public static ModConfig INSTANCE;
    private static final Gson GSON;
    public boolean globalEnabled = true;
    public boolean overridesEnabledInServerMode = false;
    public float combatCooldown = 16.0f;
    public float fadeOutTime = 2.0f;
    public final ArmorConfig global = new ArmorConfig();
    public final HashMap<UUID, ArmorConfig> overrides = new HashMap();

    public ArmorConfig getOverrideOrGlobal(UUID uuid) {
        ArmorConfig config;
        class_1657 player;
        ArmorConfig config2;
        boolean useClientValues;
        class_310 client = class_310.method_1551();
        boolean serverAvailable = ShowMeYourSkinClient.HANDSHAKE_CLIENT.getConfig().isPresent() && client.field_1687 != null;
        boolean bl = useClientValues = this.overridesEnabledInServerMode || !serverAvailable;
        if (useClientValues && (config2 = this.overrides.get(uuid)) != null) {
            return config2;
        }
        if (serverAvailable && (player = client.field_1687.method_18470(uuid)) != null && !(config = ((ArmorConfigComponent)player.getComponent(Components.ARMOR_CONFIG)).getConfig()).equals(ArmorConfig.VANILLA_VALUES)) {
            return config;
        }
        if (useClientValues) {
            return this.global;
        }
        return ArmorConfig.VANILLA_VALUES;
    }

    public ArmorConfig getApplicable(UUID uuid) {
        ArmorConfig applicable = this.getOverrideOrGlobal(uuid);
        return !this.globalEnabled || applicable.showInCombat && CombatLogger.INSTANCE.isInCombat(uuid) ? ArmorConfig.VANILLA_VALUES : applicable;
    }

    public float getApplicablePieceTransparency(UUID uuid, HideableEquipment slot) {
        return this.getApplicableTransparency(uuid, applicable -> applicable.getPieces().getOrDefault((Object)slot, ArmorConfig.ArmorPieceConfig.VANILLA_VALUES));
    }

    public float getApplicableTrimTransparency(UUID uuid, class_1304 slot) {
        return this.getApplicableTransparency(uuid, applicable -> applicable.getTrims().get(slot));
    }

    public float getApplicableGlintTransparency(UUID uuid, HideableEquipment slot) {
        return this.getApplicableTransparency(uuid, applicable -> applicable.getGlints().getOrDefault((Object)slot, ArmorConfig.ArmorPieceConfig.VANILLA_VALUES));
    }

    private float getApplicableTransparency(UUID uuid, Function<ArmorConfig, ArmorConfig.ArmorPieceConfig> configRetriever) {
        if (!this.globalEnabled) {
            return (float)configRetriever.apply(ArmorConfig.VANILLA_VALUES).getTransparency() / 100.0f;
        }
        ArmorConfig applicable = this.getOverrideOrGlobal(uuid);
        float normal = (float)configRetriever.apply(applicable).getTransparency() / 100.0f;
        if (applicable.showInCombat && CombatLogger.INSTANCE.isInCombat(uuid)) {
            return class_3532.method_37166((float)normal, (float)1.0f, (float)CombatLogger.INSTANCE.getFade(uuid));
        }
        return normal;
    }

    public ArmorConfig getOverride(UUID uuid) {
        return this.overrides.get(uuid);
    }

    public ArmorConfig getOrCreateOverride(UUID uuid) {
        ArmorConfig armorConfig = this.getOverride(uuid);
        if (armorConfig == null) {
            armorConfig = new ArmorConfig();
            this.overrides.put(uuid, armorConfig);
        }
        return armorConfig;
    }

    public void deleteOverride(UUID uuid) {
        this.overrides.remove(uuid);
    }

    public void ensureValid() {
        if (this.combatCooldown < 0.0f) {
            this.combatCooldown = 0.0f;
        }
        if (this.fadeOutTime < 0.0f) {
            this.fadeOutTime = 0.0f;
        }
        if (this.fadeOutTime > this.combatCooldown) {
            this.fadeOutTime = this.combatCooldown;
        }
        this.global.ensureValid();
        this.overrides.values().forEach(ArmorConfig::ensureValid);
        this.save();
    }

    public static void load() {
        INSTANCE = ModConfig.loadConfigFile(CONFIG_FILE);
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE);
    }

    private static ModConfig loadConfigFile(File file) {
        ModConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (ModConfig)GSON.fromJson((Reader)fileReader, ModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new ModConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    private void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    }
}

