/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.info;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefulconfig.api.types.options.TranslatableValue;
import org.intellij.lang.annotations.Pattern;
import org.intellij.lang.annotations.Subst;

public interface ResourcefulConfigLink {
    @Pattern(value="https?://(www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_+.~#?&/=]*)")
    public String url();

    public String icon();

    public TranslatableValue text();

    default public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("title", this.text().toLocalizedString());
        json.addProperty("icon", this.icon());
        json.addProperty("url", this.url());
        return json;
    }

    public static ResourcefulConfigLink create(final @Subst(value="https://example.com") @Pattern(value="https?://(www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_+.~#?&/=]*)") String url, final String icon, final TranslatableValue text) {
        return new ResourcefulConfigLink(){

            @Override
            @Pattern(value="https?://(www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_+.~#?&/=]*)")
            public String url() {
                return url;
            }

            @Override
            public String icon() {
                return icon;
            }

            @Override
            public TranslatableValue text() {
                return text;
            }
        };
    }
}

