/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.energy;

import earth.terrarium.botarium.Botarium;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.util.Updatable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class EnergyApi {
    private static final Map<Supplier<class_2591<?>>, BotariumEnergyBlock<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_2248>, BotariumEnergyBlock<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_1792>, BotariumEnergyItem<?>> ITEM_LOOKUP_MAP = new HashMap();
    private static Map<class_2591<?>, BotariumEnergyBlock<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = null;
    private static Map<class_2248, BotariumEnergyBlock<?>> FINALIZED_BLOCK_LOOKUP_MAP = null;
    private static Map<class_1792, BotariumEnergyItem<?>> FINALIZED_ITEM_LOOKUP_MAP = null;

    public static Map<class_2591<?>, BotariumEnergyBlock<?>> getBlockEntityRegistry() {
        FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_ENTITY_LOOKUP_MAP, FINALIZED_BLOCK_ENTITY_LOOKUP_MAP);
        return FINALIZED_BLOCK_ENTITY_LOOKUP_MAP;
    }

    public static Map<class_2248, BotariumEnergyBlock<?>> getBlockRegistry() {
        FINALIZED_BLOCK_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_LOOKUP_MAP, FINALIZED_BLOCK_LOOKUP_MAP);
        return FINALIZED_BLOCK_LOOKUP_MAP;
    }

    public static Map<class_1792, BotariumEnergyItem<?>> getItemRegistry() {
        FINALIZED_ITEM_LOOKUP_MAP = Botarium.finalizeRegistration(ITEM_LOOKUP_MAP, FINALIZED_ITEM_LOOKUP_MAP);
        return FINALIZED_ITEM_LOOKUP_MAP;
    }

    public static BotariumEnergyBlock<?> getEnergyBlock(class_2248 block) {
        return EnergyApi.getBlockRegistry().get(block);
    }

    public static BotariumEnergyBlock<?> getEnergyBlock(class_2591<?> blockEntity) {
        return EnergyApi.getBlockEntityRegistry().get(blockEntity);
    }

    public static BotariumEnergyItem<?> getEnergyItem(class_1792 item) {
        return EnergyApi.getItemRegistry().get(item);
    }

    public static <T extends EnergyContainer & Updatable> T getAPIEnergyContainer(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        BotariumEnergyBlock<?> getter = EnergyApi.getEnergyBlock(state.method_26204());
        if (getter == null && entity != null) {
            class_2248 class_22482;
            BotariumEnergyBlock<?> energyGetter;
            getter = EnergyApi.getEnergyBlock(entity.method_11017());
            if (getter == null && entity instanceof BotariumEnergyBlock) {
                getter = energyGetter = (BotariumEnergyBlock<?>)entity;
            }
            if (getter == null && (class_22482 = state.method_26204()) instanceof BotariumEnergyBlock) {
                getter = energyGetter = (BotariumEnergyBlock)class_22482;
            }
        }
        if (getter == null) {
            return null;
        }
        return (T)getter.getEnergyStorage(level, pos, state, entity, direction);
    }

    public static void registerEnergyBlockEntity(Supplier<class_2591<?>> block, BotariumEnergyBlock<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlockEntity(BotariumEnergyBlock<?> getter, Supplier<class_2591<?>> ... blocks) {
        for (Supplier<class_2591<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyBlock(Supplier<class_2248> block, BotariumEnergyBlock<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlock(BotariumEnergyBlock<?> getter, Supplier<class_2248> ... blocks) {
        for (Supplier<class_2248> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyItem(Supplier<class_1792> item, BotariumEnergyItem<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerEnergyItem(BotariumEnergyItem<?> getter, Supplier<class_1792> ... items) {
        for (Supplier<class_1792> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    public static long distributeEnergyNearby(class_2586 energyBlock, @Nullable class_2350 extractDirection, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.method_10997(), energyBlock.method_11016(), extractDirection, amount);
    }

    public static long distributeEnergyNearby(class_2586 energyBlock, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.method_10997(), energyBlock.method_11016(), null, amount);
    }

    public static long distributeEnergyNearby(class_1937 level, class_2338 energyPos, @Nullable class_2350 extractDirection, long amount) {
        EnergyContainer internalEnergy = EnergyContainer.of(level, energyPos, extractDirection);
        long amountToDistribute = internalEnergy.extractEnergy(amount, true);
        if (amountToDistribute == 0L) {
            return 0L;
        }
        List<EnergyContainer> list = class_2350.method_42013().map(direction -> EnergyContainer.of(level, energyPos.method_10093(direction), direction.method_10153())).filter(Objects::nonNull).sorted(Comparator.comparingLong(energy -> energy.insertEnergy(amount, true))).toList();
        int receiverCount = list.size();
        for (EnergyContainer energy2 : list) {
            if (energy2 == null) continue;
            long inserted = EnergyApi.moveEnergy(internalEnergy, energy2, amountToDistribute / (long)receiverCount, false);
            amountToDistribute -= inserted;
            --receiverCount;
        }
        return amount - amountToDistribute;
    }

    public static long moveEnergy(EnergyContainer from, EnergyContainer to, long amount, boolean simulate) {
        long extracted = from.extractEnergy(amount, true);
        long inserted = to.insertEnergy(extracted, true);
        long simulatedExtraction = from.extractEnergy(inserted, true);
        if (!simulate && inserted > 0L && simulatedExtraction == inserted) {
            from.extractEnergy(inserted, false);
            to.insertEnergy(inserted, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveEnergy(ItemStackHolder from, ItemStackHolder to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from);
        EnergyContainer toEnergy = EnergyContainer.of(to);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(class_2586 from, class_2586 to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from, null);
        EnergyContainer toEnergy = EnergyContainer.of(to, null);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(class_1937 level, class_2338 fromPos, @Nullable class_2350 fromDirection, class_2338 toPos, @Nullable class_2350 toDirection, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(level, fromPos, fromDirection);
        EnergyContainer toEnergy = EnergyContainer.of(level, toPos, toDirection);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(class_2586 from, class_2350 direction, ItemStackHolder to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from, direction);
        EnergyContainer toEnergy = EnergyContainer.of(to);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(ItemStackHolder from, class_2586 to, class_2350 direction, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from);
        EnergyContainer toEnergy = EnergyContainer.of(to, direction);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }
}

