/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid;

import earth.terrarium.botarium.Botarium;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.util.Updatable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class FluidApi {
    private static final Map<Supplier<class_2591<?>>, BotariumFluidBlock<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_2248>, BotariumFluidBlock<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_1792>, BotariumFluidItem<?>> ITEM_LOOKUP_MAP = new HashMap();
    private static Map<class_2591<?>, BotariumFluidBlock<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = null;
    private static Map<class_2248, BotariumFluidBlock<?>> FINALIZED_BLOCK_LOOKUP_MAP = null;
    private static Map<class_1792, BotariumFluidItem<?>> FINALIZED_ITEM_LOOKUP_MAP = null;

    public static Map<class_2591<?>, BotariumFluidBlock<?>> getBlockEntityRegistry() {
        FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_ENTITY_LOOKUP_MAP, FINALIZED_BLOCK_ENTITY_LOOKUP_MAP);
        return FINALIZED_BLOCK_ENTITY_LOOKUP_MAP;
    }

    public static Map<class_2248, BotariumFluidBlock<?>> getBlockRegistry() {
        FINALIZED_BLOCK_LOOKUP_MAP = Botarium.finalizeRegistration(BLOCK_LOOKUP_MAP, FINALIZED_BLOCK_LOOKUP_MAP);
        return FINALIZED_BLOCK_LOOKUP_MAP;
    }

    public static Map<class_1792, BotariumFluidItem<?>> getItemRegistry() {
        FINALIZED_ITEM_LOOKUP_MAP = Botarium.finalizeRegistration(ITEM_LOOKUP_MAP, FINALIZED_ITEM_LOOKUP_MAP);
        return FINALIZED_ITEM_LOOKUP_MAP;
    }

    public static BotariumFluidBlock<?> getFluidBlock(class_2248 block) {
        return FluidApi.getBlockRegistry().get(block);
    }

    public static BotariumFluidBlock<?> getFluidBlock(class_2591<?> blockEntity) {
        return FluidApi.getBlockEntityRegistry().get(blockEntity);
    }

    public static BotariumFluidItem<?> getFluidItem(class_1792 item) {
        return FluidApi.getItemRegistry().get(item);
    }

    public static <T extends FluidContainer & Updatable> T getAPIFluidContainer(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        BotariumFluidBlock<?> getter = FluidApi.getFluidBlock(state.method_26204());
        if (getter == null && entity != null) {
            class_2248 class_22482;
            BotariumFluidBlock<?> fluidGetter;
            getter = FluidApi.getFluidBlock(entity.method_11017());
            if (getter == null && entity instanceof BotariumFluidBlock) {
                getter = fluidGetter = (BotariumFluidBlock<?>)entity;
            }
            if (getter == null && (class_22482 = state.method_26204()) instanceof BotariumFluidBlock) {
                getter = fluidGetter = (BotariumFluidBlock)class_22482;
            }
        }
        if (getter == null) {
            return null;
        }
        return (T)getter.getFluidContainer(level, pos, state, entity, direction);
    }

    public static void registerFluidBlockEntity(Supplier<class_2591<?>> block, BotariumFluidBlock<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlockEntity(BotariumFluidBlock<?> getter, Supplier<class_2591<?>> ... blocks) {
        for (Supplier<class_2591<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidBlock(Supplier<class_2248> block, BotariumFluidBlock<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlock(BotariumFluidBlock<?> getter, Supplier<class_2248> ... blocks) {
        for (Supplier<class_2248> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidItem(Supplier<class_1792> item, BotariumFluidItem<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerFluidItem(BotariumFluidItem<?> getter, Supplier<class_1792> ... items) {
        for (Supplier<class_1792> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    public static long moveFluid(FluidContainer from, FluidContainer to, FluidHolder amount, boolean simulate) {
        FluidHolder extracted = from.extractFluid(amount, true);
        long inserted = to.insertFluid(extracted, true);
        FluidHolder toInsert = amount.copyWithAmount(inserted);
        FluidHolder simulatedExtraction = from.extractFluid(toInsert, true);
        if (!simulate && inserted > 0L && simulatedExtraction.getFluidAmount() == inserted) {
            from.extractFluid(toInsert, false);
            to.insertFluid(toInsert, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveFluid(ItemStackHolder from, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        ItemFluidContainer fromFluid = FluidContainer.of(from);
        ItemFluidContainer toFluid = FluidContainer.of(to);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(class_2586 from, class_2586 to, FluidHolder fluidHolder, boolean simulate) {
        FluidContainer fromFluid = FluidContainer.of(from, null);
        FluidContainer toFluid = FluidContainer.of(to, null);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(class_1937 level, class_2338 fromPos, @Nullable class_2350 fromDirection, class_2338 toPos, @Nullable class_2350 toDirection, FluidHolder fluidHolder, boolean simulate) {
        FluidContainer fromFluid = FluidContainer.of(level, fromPos, fromDirection);
        FluidContainer toFluid = FluidContainer.of(level, toPos, toDirection);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(class_2586 from, class_2350 direction, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        FluidContainer fromFluid = FluidContainer.of(from, direction);
        ItemFluidContainer toFluid = FluidContainer.of(to);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(ItemStackHolder from, class_2586 to, class_2350 direction, FluidHolder fluidHolder, boolean simulate) {
        ItemFluidContainer fromFluid = FluidContainer.of(from);
        FluidContainer toFluid = FluidContainer.of(to, direction);
        if (fromFluid == null || toFluid == null) {
            return 0L;
        }
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }
}

