/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minelittlepony.common.util.settings.Config;
import com.minelittlepony.common.util.settings.Grouping;
import com.minelittlepony.common.util.settings.Setting;
import com.minelittlepony.common.util.settings.SettingSerializer;
import com.minelittlepony.common.util.settings.ToStringAdapter;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class LegacyJsonConfigAdapter
implements Config.Adapter {
    private static final Logger logger = LogManager.getLogger();
    private final Gson gson;
    public static final LegacyJsonConfigAdapter DEFAULT = new LegacyJsonConfigAdapter(new GsonBuilder());

    public LegacyJsonConfigAdapter(GsonBuilder builder) {
        this.gson = builder.setPrettyPrinting().registerTypeHierarchyAdapter(Path.class, new ToStringAdapter<Path>(x$0 -> Paths.get(x$0, new String[0]))).registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeHierarchyAdapter(Setting.class, (Object)new SettingSerializer()).create();
    }

    @Override
    public void save(Config config, Path file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.gson.toJson(config.categories().map(Map.Entry::getValue).flatMap(Grouping::stream).collect(Collectors.toMap(Setting::name, s -> s)), HashMap.class, (Appendable)writer);
        }
        catch (IOException e) {
            logger.warn("Error whilst saving Json config", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Config config, Path file) {
        block11: {
            try {
                if (!Files.isReadable(file)) break block11;
                try (BufferedReader s = Files.newBufferedReader(file);){
                    ((JsonObject)this.gson.fromJson((Reader)s, JsonObject.class)).entrySet().forEach(entry -> {
                        String key = ((String)entry.getKey()).toLowerCase();
                        Setting<Object> setting = config.get(key);
                        if (setting != null) {
                            setting.set(this.gson.getAdapter(setting.getType().token()).fromJsonTree((JsonElement)entry.getValue()));
                        }
                    });
                }
                catch (JsonParseException | IOException e) {
                    logger.warn("Erorr whilst loading json config", e);
                }
            }
            finally {
                this.save(config, file);
            }
        }
    }
}

