/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common.modimpl;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.class_3532;
import net.minecraft.class_8257;

public abstract class LevelPropagatorExtended {
    public static final long MARKER = Long.MAX_VALUE;
    public static final int MAX_LEVEL = 0x3FFFFFFF;
    protected final int levelCount;
    private final class_8257 pendingUpdateQueue;
    private final Long2IntMap pendingUpdates;
    private volatile boolean hasPendingUpdates;

    protected LevelPropagatorExtended(int levelCount, int expectedLevelSize, final int expectedTotalSize) {
        if (levelCount >= 0x3FFFFFFE) {
            throw new IllegalArgumentException("Level count must be < %d.".formatted(0x3FFFFFFE));
        }
        this.levelCount = levelCount;
        this.pendingUpdateQueue = new class_8257(levelCount, expectedLevelSize);
        this.pendingUpdates = new Long2IntOpenHashMap(expectedTotalSize, 0.5f){

            protected void rehash(int newN) {
                if (newN > expectedTotalSize) {
                    super.rehash(newN);
                }
            }
        };
        this.pendingUpdates.defaultReturnValue(-1);
    }

    protected void removePendingUpdate(long id) {
        int i = this.pendingUpdates.remove(id) & 0x3FFFFFFF;
        if (i != 0x3FFFFFFF) {
            int j = this.getLevel(id);
            int k = this.calculateLevel(j, i);
            this.pendingUpdateQueue.method_50022(id, k, this.levelCount);
            this.hasPendingUpdates = !this.pendingUpdateQueue.method_50023();
        }
    }

    public void removePendingUpdateIf(LongPredicate predicate) {
        LongArrayList longList = new LongArrayList();
        this.pendingUpdates.keySet().forEach(arg_0 -> LevelPropagatorExtended.lambda$removePendingUpdateIf$0(predicate, (LongList)longList, arg_0));
        longList.forEach(this::removePendingUpdate);
    }

    private int calculateLevel(int a, int b) {
        return Math.min(Math.min(a, b), this.levelCount - 1);
    }

    protected void resetLevel(long id) {
        this.updateLevel(id, id, this.levelCount - 1, false);
    }

    protected void updateLevel(long sourceId, long id, int level, boolean decrease) {
        this.updateLevel(sourceId, id, level, this.getLevel(id), this.pendingUpdates.get(id) & 0x3FFFFFFF, decrease);
        this.hasPendingUpdates = !this.pendingUpdateQueue.method_50023();
    }

    private void updateLevel(long sourceId, long id, int level, int currentLevel, int i, boolean decrease) {
        if (!this.isMarker(id)) {
            boolean bl;
            level = class_3532.method_15340((int)level, (int)0, (int)(this.levelCount - 1));
            currentLevel = class_3532.method_15340((int)currentLevel, (int)0, (int)(this.levelCount - 1));
            boolean bl2 = bl = i == 0x3FFFFFFF;
            if (bl) {
                i = currentLevel;
            }
            int j = decrease ? Math.min(i, level) : class_3532.method_15340((int)this.recalculateLevel(id, sourceId, level), (int)0, (int)(this.levelCount - 1));
            int k = this.calculateLevel(currentLevel, i);
            if (currentLevel != j) {
                int l = this.calculateLevel(currentLevel, j);
                if (k != l && !bl) {
                    this.pendingUpdateQueue.method_50022(id, k, l);
                }
                this.pendingUpdateQueue.method_50021(id, l);
                this.pendingUpdates.put(id, j);
            } else if (!bl) {
                this.pendingUpdateQueue.method_50022(id, k, this.levelCount);
                this.pendingUpdates.remove(id);
            }
        }
    }

    protected final void propagateLevel(long sourceId, long targetId, int level, boolean decrease) {
        int i = this.pendingUpdates.get(targetId) & 0x3FFFFFFF;
        int j = class_3532.method_15340((int)this.getPropagatedLevel(sourceId, targetId, level), (int)0, (int)(this.levelCount - 1));
        if (decrease) {
            this.updateLevel(sourceId, targetId, j, this.getLevel(targetId), i, decrease);
        } else {
            boolean bl = i == 0x3FFFFFFF;
            int k = bl ? class_3532.method_15340((int)this.getLevel(targetId), (int)0, (int)(this.levelCount - 1)) : i;
            if (j == k) {
                this.updateLevel(sourceId, targetId, this.levelCount - 1, bl ? k : this.getLevel(targetId), i, decrease);
            }
        }
    }

    protected final boolean hasPendingUpdates() {
        return this.hasPendingUpdates;
    }

    protected final int applyPendingUpdates(int maxSteps) {
        if (this.pendingUpdateQueue.method_50023()) {
            return maxSteps;
        }
        while (!this.pendingUpdateQueue.method_50023() && maxSteps > 0) {
            --maxSteps;
            long l = this.pendingUpdateQueue.method_50019();
            int i = class_3532.method_15340((int)this.getLevel(l), (int)0, (int)(this.levelCount - 1));
            int j = this.pendingUpdates.remove(l) & 0x3FFFFFFF;
            if (j < i) {
                this.setLevel(l, j);
                this.propagateLevel(l, j, true);
                continue;
            }
            if (j <= i) continue;
            this.setLevel(l, this.levelCount - 1);
            if (j != this.levelCount - 1) {
                this.pendingUpdateQueue.method_50021(l, this.calculateLevel(this.levelCount - 1, j));
                this.pendingUpdates.put(l, j);
            }
            this.propagateLevel(l, i, false);
        }
        this.hasPendingUpdates = !this.pendingUpdateQueue.method_50023();
        return maxSteps;
    }

    public int getPendingUpdateCount() {
        return this.pendingUpdates.size();
    }

    protected boolean isMarker(long id) {
        return id == Long.MAX_VALUE;
    }

    protected abstract int recalculateLevel(long var1, long var3, int var5);

    protected abstract void propagateLevel(long var1, int var3, boolean var4);

    protected abstract int getLevel(long var1);

    protected abstract void setLevel(long var1, int var3);

    protected abstract int getPropagatedLevel(long var1, long var3, int var5);

    private static /* synthetic */ void lambda$removePendingUpdateIf$0(LongPredicate predicate, LongList longList, long l) {
        if (predicate.test(l)) {
            longList.add(l);
        }
    }
}

