/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.mixin;

import com.ishland.c2me.notickvd.common.IChunkTicketManager;
import com.ishland.c2me.notickvd.common.NoOPTickingMap;
import com.ishland.c2me.notickvd.common.NoTickSystem;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_3204;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_6609;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3204.class})
public class MixinChunkTicketManager
implements IChunkTicketManager {
    @Shadow
    private long field_13894;
    @Mutable
    @Shadow
    @Final
    private class_6609 field_34886;
    @Shadow
    @Final
    private class_3204.class_3948 field_17455;
    @Unique
    private NoTickSystem noTickSystem;
    @Unique
    private long lastNoTickSystemTick = -1L;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.noTickSystem = new NoTickSystem((class_3204)this);
        this.field_34886 = new NoOPTickingMap();
    }

    @Inject(method={"handleChunkEnter"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$DistanceFromNearestPlayerTracker;updateLevel(JIZ)V", ordinal=0, shift=At.Shift.AFTER)})
    private void onHandleChunkEnter(class_4076 pos, class_3222 player, CallbackInfo ci) {
        this.noTickSystem.addPlayerSource(pos.method_18692());
    }

    @Inject(method={"handleChunkLeave"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$DistanceFromNearestPlayerTracker;updateLevel(JIZ)V", ordinal=0, shift=At.Shift.AFTER)})
    private void onHandleChunkLeave(class_4076 pos, class_3222 player, CallbackInfo ci) {
        this.noTickSystem.removePlayerSource(pos.method_18692());
    }

    @Inject(method={"purge"}, at={@At(value="RETURN")})
    private void onPurge(CallbackInfo ci) {
        this.noTickSystem.runPurge(this.field_13894);
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void beforeTick(class_3898 chunkStorage, CallbackInfoReturnable<Boolean> cir) {
        this.noTickSystem.beforeTicketTicks();
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void onTick(class_3898 chunkStorage, CallbackInfoReturnable<Boolean> cir) {
        class_6609 class_66092 = this.field_34886;
        if (class_66092 instanceof NoOPTickingMap) {
            NoOPTickingMap map = (NoOPTickingMap)class_66092;
            map.setTACS(chunkStorage);
        }
        this.noTickSystem.tickScheduler();
        this.noTickSystem.afterTicketTicks();
        if (this.lastNoTickSystemTick != this.field_13894) {
            this.noTickSystem.tick(chunkStorage);
            this.lastNoTickSystemTick = this.field_13894;
        }
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="RETURN")})
    private void onAddTicket(long position, class_3228<?> ticket, CallbackInfo ci) {
        this.noTickSystem.onTicketAdded(position, ticket);
    }

    @Inject(method={"removeTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="RETURN")})
    private void onRemoveTicket(long pos, class_3228<?> ticket, CallbackInfo ci) {
        this.noTickSystem.onTicketRemoved(pos, ticket);
    }

    @Overwrite
    public void method_38629(int i) {
        this.field_17455.method_17658(i);
    }

    @Overwrite
    public void method_14049(int viewDistance) {
        this.noTickSystem.setNoTickViewDistance(viewDistance);
    }

    @Override
    @Unique
    public LongSet getNoTickOnlyChunks() {
        return this.noTickSystem.getNoTickOnlyChunksSnapshot();
    }

    @Override
    @Unique
    public int getNoTickPendingTicketUpdates() {
        return this.noTickSystem.getPendingNoTickTicketUpdatesCount();
    }
}

