/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.internal.CborDecoder;
import kotlinx.serialization.cbor.internal.CborListReader;
import kotlinx.serialization.cbor.internal.CborMapReader;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0004J\b\u0010\u001b\u001a\u00020\u0016H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J!\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000fH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u000bH\u0016J\b\u00106\u001a\u000207H\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u001fH\u0016J\b\u0010<\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006="}, d2={"Lkotlinx/serialization/cbor/internal/CborReader;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "cbor", "Lkotlinx/serialization/cbor/Cbor;", "decoder", "Lkotlinx/serialization/cbor/internal/CborDecoder;", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborDecoder;)V", "getDecoder", "()Lkotlinx/serialization/cbor/internal/CborDecoder;", "value", "", "size", "getSize", "()I", "", "finiteMode", "getFiniteMode", "()Z", "readProperties", "decodeByteArrayAsByteString", "setSize", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "skipBeginToken", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "endStructure", "decodeElementIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeString", "", "decodeNotNullMark", "decodeDouble", "", "decodeFloat", "", "decodeBoolean", "decodeByte", "", "decodeShort", "", "decodeChar", "", "decodeInt", "decodeLong", "", "decodeNull", "", "decodeEnum", "enumDescriptor", "isDone", "kotlinx-serialization-cbor"})
public class CborReader
extends AbstractDecoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final CborDecoder decoder;
    private int size;
    private boolean finiteMode;
    private int readProperties;
    private boolean decodeByteArrayAsByteString;

    public CborReader(@NotNull Cbor cbor, @NotNull CborDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)cbor, (String)"cbor");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        this.cbor = cbor;
        this.decoder = decoder;
        this.size = -1;
    }

    @NotNull
    protected final CborDecoder getDecoder() {
        return this.decoder;
    }

    protected final int getSize() {
        return this.size;
    }

    protected final boolean getFiniteMode() {
        return this.finiteMode;
    }

    protected final void setSize(int size) {
        if (size >= 0) {
            this.finiteMode = true;
            this.size = size;
        }
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.cbor.getSerializersModule();
    }

    protected void skipBeginToken() {
        this.setSize(this.decoder.startMap());
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        CborReader re = Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind ? (CborReader)new CborListReader(this.cbor, this.decoder) : (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? (CborReader)new CborMapReader(this.cbor, this.decoder) : new CborReader(this.cbor, this.decoder));
        re.skipBeginToken();
        return (CompositeDecoder)re;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.finiteMode) {
            this.decoder.end();
        }
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.cbor.getIgnoreUnknownKeys$kotlinx_serialization_cbor()) {
            int index;
            int knownIndex = 0;
            while (true) {
                if (this.isDone()) {
                    return -1;
                }
                String elemName = this.decoder.nextString();
                int n2 = this.readProperties;
                this.readProperties = n2 + 1;
                index = descriptor.getElementIndex(elemName);
                if (index != -3) break;
                this.decoder.skipElement();
            }
            n = knownIndex = index;
        } else {
            if (this.isDone()) {
                return -1;
            }
            String elemName = this.decoder.nextString();
            int n3 = this.readProperties;
            this.readProperties = n3 + 1;
            n = EncodingKt.access$getElementIndexOrThrow(descriptor, elemName);
        }
        int index = n;
        this.decodeByteArrayAsByteString = EncodingKt.access$isByteString(descriptor, index);
        return index;
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Object object;
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        if (this.decodeByteArrayAsByteString && Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            object = this.decoder.nextByteString();
        } else {
            this.decodeByteArrayAsByteString = this.decodeByteArrayAsByteString || EncodingKt.access$isInlineByteString(deserializer.getDescriptor());
            object = super.decodeSerializableValue(deserializer);
        }
        return (T)object;
    }

    @NotNull
    public String decodeString() {
        return this.decoder.nextString();
    }

    public boolean decodeNotNullMark() {
        return !this.decoder.isNull();
    }

    public double decodeDouble() {
        return this.decoder.nextDouble();
    }

    public float decodeFloat() {
        return this.decoder.nextFloat();
    }

    public boolean decodeBoolean() {
        return this.decoder.nextBoolean();
    }

    public byte decodeByte() {
        return (byte)this.decoder.nextNumber();
    }

    public short decodeShort() {
        return (short)this.decoder.nextNumber();
    }

    public char decodeChar() {
        return (char)this.decoder.nextNumber();
    }

    public int decodeInt() {
        return (int)this.decoder.nextNumber();
    }

    public long decodeLong() {
        return this.decoder.nextNumber();
    }

    @Nullable
    public Void decodeNull() {
        return this.decoder.nextNull();
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return EncodingKt.access$getElementIndexOrThrow(enumDescriptor, this.decoder.nextString());
    }

    private final boolean isDone() {
        return !this.finiteMode && this.decoder.isEnd() || this.finiteMode && this.readProperties >= this.size;
    }
}

