/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.loader;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.Configurations;
import com.teamresourceful.resourcefulconfig.common.loader.Parser;
import com.teamresourceful.resourcefulconfig.common.utils.ModUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;

public final class Configurator {
    private final Map<String, ResourcefulConfig> configs = new ConcurrentHashMap<String, ResourcefulConfig>();
    private final Map<Class<?>, String> configClasses = new ConcurrentHashMap();
    private final String modid;

    public Configurator(String modid) {
        this.modid = modid;
    }

    public void register(Class<?> clazz) {
        ResourcefulConfig config = this.registerConfig(clazz);
        if (config != null) {
            this.configClasses.put(clazz, config.id());
            this.register(config);
        }
    }

    public void register(ResourcefulConfig config) {
        this.configs.put(config.id(), config);
        Configurations.INSTANCE.addConfig(config, this.modid);
    }

    @ApiStatus.Internal
    private ResourcefulConfig registerConfig(Class<?> clazz) {
        try {
            ResourcefulConfig config = Parser.parse(clazz);
            config.load();
            config.save();
            return config;
        }
        catch (Exception e) {
            ModUtils.log("Failed to create config for " + clazz.getName(), e);
            return null;
        }
    }

    public boolean saveConfig(Class<?> config) {
        if (this.configClasses.containsKey(config)) {
            return this.saveConfig(this.configClasses.get(config));
        }
        return false;
    }

    public boolean saveConfig(String fileName) {
        ResourcefulConfig config = this.getConfig(fileName);
        if (config != null) {
            config.save();
            return true;
        }
        return false;
    }

    public boolean loadConfig(Class<?> config) {
        if (this.configClasses.containsKey(config)) {
            return this.loadConfig(this.configClasses.get(config));
        }
        return false;
    }

    public boolean loadConfig(String fileName) {
        ResourcefulConfig config = this.getConfig(fileName);
        if (config != null) {
            config.load();
            return true;
        }
        return false;
    }

    public ResourcefulConfig getConfig(String fileName) {
        return this.configs.get(fileName);
    }

    public ResourcefulConfig getConfig(Class<?> config) {
        if (this.configClasses.containsKey(config)) {
            return this.getConfig(this.configClasses.get(config));
        }
        return null;
    }
}

