/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.canceller;

import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import com.bawnorton.mixinsquared.reflection.TargetClassContextAccess;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.MixinService;

public final class ExtensionCancelApplication
implements IExtension {
    private static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared");

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
        SortedSet<IMixinInfo> mixins = TargetClassContextAccess.getMixins(context);
        mixins.removeIf(mixin -> {
            List<String> targetClasses = mixin.getTargetClasses().stream().map(s -> s.replaceAll("/", ".")).collect(Collectors.toList());
            boolean shouldCancel = MixinCancellerRegistrar.shouldCancel(targetClasses, mixin.getClassName());
            if (shouldCancel) {
                LOGGER.debug("Cancelling mixin {}", new Object[]{mixin.getClassName()});
            }
            return shouldCancel;
        });
    }

    public void postApply(ITargetClassContext context) {
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }
}

