/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.tools;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public final class MixinAnnotationReader {
    private static final IClassBytecodeProvider bytecodeProvider = MixinService.getService().getBytecodeProvider();
    private final AnnotationNode mixinAnnotation;

    public MixinAnnotationReader(String mixinClassName) {
        try {
            ClassNode classNode = bytecodeProvider.getClassNode(mixinClassName);
            this.mixinAnnotation = Annotations.getInvisible((ClassNode)classNode, Mixin.class);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public MixinAnnotationReader(ClassNode mixinClassNode) {
        this.mixinAnnotation = Annotations.getInvisible((ClassNode)mixinClassNode, Mixin.class);
    }

    public List<Type> getValue() {
        return (List)Annotations.getValue((AnnotationNode)this.mixinAnnotation, (String)"value", Collections.emptyList());
    }

    public List<String> getTargets() {
        return (List)Annotations.getValue((AnnotationNode)this.mixinAnnotation, (String)"targets", Collections.emptyList());
    }

    public int getPriority() {
        return (Integer)Annotations.getValue((AnnotationNode)this.mixinAnnotation, (String)"priority", (Object)1000);
    }

    public boolean getRemap() {
        return (Boolean)Annotations.getValue((AnnotationNode)this.mixinAnnotation, (String)"remap", (Object)Boolean.TRUE);
    }

    public static List<Type> getValue(String mixinClassName) {
        return new MixinAnnotationReader(mixinClassName).getValue();
    }

    public static List<String> getTargets(String mixinClassName) {
        return new MixinAnnotationReader(mixinClassName).getTargets();
    }

    public static int getPriority(String mixinClassName) {
        return new MixinAnnotationReader(mixinClassName).getPriority();
    }

    public static boolean getRemap(String mixinClassName) {
        return new MixinAnnotationReader(mixinClassName).getRemap();
    }

    public static List<Type> getValue(ClassNode mixinClassNode) {
        return new MixinAnnotationReader(mixinClassNode).getValue();
    }

    public static List<String> getTargets(ClassNode mixinClassNode) {
        return new MixinAnnotationReader(mixinClassNode).getTargets();
    }

    public static int getPriority(ClassNode mixinClassNode) {
        return new MixinAnnotationReader(mixinClassNode).getPriority();
    }

    public static boolean getRemap(ClassNode mixinClassNode) {
        return new MixinAnnotationReader(mixinClassNode).getRemap();
    }
}

