/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.client.uncapvd.common;

import com.ishland.c2me.base.common.network.ExtRenderDistance;
import com.ishland.c2me.client.uncapvd.common.Config;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExtNetworking {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME ClientExtNetworking");

    public static void sendViewDistance(int viewDistance) {
        if (!class_310.method_1551().method_18854()) {
            new IllegalStateException("Tried to send packet not on client thread!").printStackTrace();
            return;
        }
        if (ClientExtNetworking.catchExceptions(() -> ClientPlayNetworking.canSend((PacketType)ExtRenderDistance.TYPE))) {
            LOGGER.info("Changing view distance to {} (play stage)", (Object)viewDistance);
            ClientPlayNetworking.send((FabricPacket)new ExtRenderDistance(viewDistance));
            return;
        }
        if (ClientExtNetworking.catchExceptions(() -> ClientConfigurationNetworking.canSend((PacketType)ExtRenderDistance.TYPE))) {
            LOGGER.info("Changing view distance to {} (config stage)", (Object)viewDistance);
            ClientConfigurationNetworking.send((FabricPacket)new ExtRenderDistance(viewDistance));
            return;
        }
    }

    private static boolean catchExceptions(BooleanSupplier supplier) {
        try {
            return supplier.getAsBoolean();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static void registerListeners() {
        C2SPlayChannelEvents.REGISTER.register((handler, sender, client, channels) -> {
            if (channels.contains(ExtRenderDistance.TYPE.getId())) {
                if (Config.enableExtRenderDistanceProtocol) {
                    LOGGER.info("Joined server with {} support", (Object)ExtRenderDistance.TYPE.getId());
                    class_310.method_1551().execute(() -> class_310.method_1551().field_1690.method_1643());
                } else {
                    LOGGER.info("Server supports {} but it is disabled in config", (Object)ExtRenderDistance.TYPE.getId());
                }
            }
        });
    }
}

