/*
 * Decompiled with CFR 0.152.
 */
package net.crazedaerialcable.weaponworks.config;

import io.github.hornster.itemfig.api.serialization.ItemFigApi;
import io.github.hornster.itemfig.api.serialization.config.ConfigObj;
import io.github.hornster.itemfig.api.serialization.config.ConfigObjAdapterConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.crazedaerialcable.weaponworks.Weaponworks;
import net.crazedaerialcable.weaponworks.config.helpers.ConfigHelper;
import net.crazedaerialcable.weaponworks.config.objectAdaptersConfigs.ObjectAdaptersConfigsFactory;
import net.crazedaerialcable.weaponworks.config.objects.ConfigObjectFactory;
import net.crazedaerialcable.weaponworks.config.objects.WeaponConfigObj;
import net.crazedaerialcable.weaponworks.enums.WeaponTypesEnum;
import net.minecraft.class_1834;
import org.slf4j.Logger;

public class WeaponworksConfig {
    public static Map<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>> WEAPON_CONFIGS;
    public static Map CONFIG;

    private static void registerConfigObj(ObjectAdaptersConfigsFactory adapterConfigFactory, ConfigObjectFactory configObjFactory, WeaponTypesEnum weaponType, class_1834 tier) throws Exception {
        ConfigObjAdapterConfig<?> adapterConfig = adapterConfigFactory.createObjectAdapterConfig(weaponType, tier);
        ConfigObj configObj = configObjFactory.createObjectConfig(weaponType, tier);
        ItemFigApi.registerObject((ConfigObj)configObj, adapterConfig);
    }

    private static void registerItemsConfigs() {
        ObjectAdaptersConfigsFactory adapterConfigFactory = new ObjectAdaptersConfigsFactory();
        ConfigObjectFactory configObjFactory = new ConfigObjectFactory();
        Logger logger = Weaponworks.LOGGER;
        for (WeaponTypesEnum weaponType : WeaponTypesEnum.values()) {
            for (class_1834 tier : class_1834.values()) {
                try {
                    WeaponworksConfig.registerConfigObj(adapterConfigFactory, configObjFactory, weaponType, tier);
                }
                catch (Exception ex) {
                    logger.warn(ex.getMessage());
                }
            }
        }
    }

    private static Map<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>> getAllElements() {
        WeaponTypesEnum[] weaponTypes = WeaponTypesEnum.values();
        class_1834[] toolMaterials = class_1834.values();
        LinkedHashMap<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>> result = new LinkedHashMap<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>>();
        for (WeaponTypesEnum weaponType : weaponTypes) {
            LinkedHashMap<class_1834, WeaponConfigObj> weaponConfigsByTier = new LinkedHashMap<class_1834, WeaponConfigObj>();
            for (class_1834 tier : toolMaterials) {
                String weaponId = ConfigHelper.getWeaponId(weaponType, tier);
                WeaponConfigObj config = (WeaponConfigObj)ItemFigApi.getItemConfig((String)weaponId);
                if (config == null) continue;
                weaponConfigsByTier.put(tier, config);
            }
            result.put(weaponType, weaponConfigsByTier);
        }
        return result;
    }

    public static void register() {
        ItemFigApi.setConfigFileName((String)"weaponworks-if-common.json");
        WeaponworksConfig.registerItemsConfigs();
        ItemFigApi.readConfig();
        WEAPON_CONFIGS = WeaponworksConfig.getAllElements();
    }

    static {
        CONFIG = new TreeMap();
    }
}

