/*
 * Decompiled with CFR 0.152.
 */
package net.crazedaerialcable.weaponworks.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.crazedaerialcable.weaponworks.Weaponworks;
import net.crazedaerialcable.weaponworks.config.WeaponworksConfig;
import net.crazedaerialcable.weaponworks.config.objects.WeaponConfigObj;
import net.crazedaerialcable.weaponworks.enums.WeaponTypesEnum;
import net.crazedaerialcable.weaponworks.item.weapons.GreatswordItem;
import net.crazedaerialcable.weaponworks.item.weapons.HalberdItem;
import net.crazedaerialcable.weaponworks.item.weapons.HammerItem;
import net.crazedaerialcable.weaponworks.item.weapons.KatanaItem;
import net.crazedaerialcable.weaponworks.item.weapons.MaceItem;
import net.crazedaerialcable.weaponworks.item.weapons.RapierItem;
import net.crazedaerialcable.weaponworks.item.weapons.ScytheItem;
import net.crazedaerialcable.weaponworks.item.weapons.SpearItem;
import net.crazedaerialcable.weaponworks.item.weapons.WarglaiveItem;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1834;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class ModItems {
    public static final List<class_1792> WEAPONS = new ArrayList<class_1792>();
    public static final HashMap<class_2960, class_1792> WEAPONS_MAP = new HashMap();

    public static Map<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>> sortItems() {
        LinkedHashMap<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>> itemsToRegister = new LinkedHashMap<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>>();
        for (WeaponTypesEnum weaponType : WeaponworksConfig.WEAPON_CONFIGS.keySet()) {
            LinkedHashMap<class_1834, WeaponConfigObj> sortedWeaponTypeItems = new LinkedHashMap<class_1834, WeaponConfigObj>();
            Map<class_1834, WeaponConfigObj> weaponTypeItems = WeaponworksConfig.WEAPON_CONFIGS.get((Object)weaponType);
            for (class_1834 tier : class_1834.values()) {
                if (!weaponTypeItems.containsKey(tier)) continue;
                WeaponConfigObj itemConfig = weaponTypeItems.get(tier);
                sortedWeaponTypeItems.put(tier, itemConfig);
            }
            itemsToRegister.put(weaponType, sortedWeaponTypeItems);
        }
        return itemsToRegister;
    }

    private static void addItemToCombatItemGroup(FabricItemGroupEntries entries) {
        for (class_1792 weapon : WEAPONS) {
            entries.method_45421((class_1935)weapon);
        }
    }

    private static class_1792 registerItem(String name, class_1792 item) {
        class_2960 itemIdentifier = new class_2960("weaponworks", name);
        WEAPONS.add(item);
        WEAPONS_MAP.put(itemIdentifier, item);
        return (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)itemIdentifier, (Object)item);
    }

    public static void registerModItems() {
        Weaponworks.LOGGER.info("Registering Mod Items for weaponworks");
        try {
            Map<WeaponTypesEnum, Map<class_1834, WeaponConfigObj>> weaponConfigs = ModItems.sortItems();
            Set<WeaponTypesEnum> weaponConfigTypes = weaponConfigs.keySet();
            for (WeaponTypesEnum weaponType : weaponConfigTypes) {
                Map<class_1834, WeaponConfigObj> weaponCategory = weaponConfigs.get((Object)weaponType);
                block14: for (Map.Entry<class_1834, WeaponConfigObj> entry : weaponCategory.entrySet()) {
                    WeaponConfigObj weaponConfig = entry.getValue();
                    String weaponId = weaponConfig.getConfigObjId();
                    switch (weaponType) {
                        case GREATSWORD: {
                            ModItems.registerItem(weaponId, (class_1792)new GreatswordItem(weaponConfig));
                            continue block14;
                        }
                        case HALBERD: {
                            ModItems.registerItem(weaponId, (class_1792)new HalberdItem(weaponConfig));
                            continue block14;
                        }
                        case HAMMER: {
                            ModItems.registerItem(weaponId, (class_1792)new HammerItem(weaponConfig));
                            continue block14;
                        }
                        case KATANA: {
                            ModItems.registerItem(weaponId, (class_1792)new KatanaItem(weaponConfig));
                            continue block14;
                        }
                        case RAPIER: {
                            ModItems.registerItem(weaponId, (class_1792)new RapierItem(weaponConfig));
                            continue block14;
                        }
                        case SCYTHE: {
                            ModItems.registerItem(weaponId, (class_1792)new ScytheItem(weaponConfig));
                            continue block14;
                        }
                        case WARGLAIVE: {
                            ModItems.registerItem(weaponId, (class_1792)new WarglaiveItem(weaponConfig));
                            continue block14;
                        }
                        case SPEAR: {
                            ModItems.registerItem(weaponId, (class_1792)new SpearItem(weaponConfig));
                            continue block14;
                        }
                        case MACE: {
                            ModItems.registerItem(weaponId, (class_1792)new MaceItem(weaponConfig));
                            continue block14;
                        }
                    }
                    throw new Exception("Unknown weapon type to load: " + weaponId);
                }
            }
        }
        catch (Exception ex) {
            Weaponworks.LOGGER.error("Failed to load weapons: " + ex.getMessage());
        }
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202).register(ModItems::addItemToCombatItemGroup);
    }
}

