/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.ContainerHelper;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.collections.ConcurrentArrayList;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.SortUtils;

public abstract class AbstractPriorityScheduler
extends AbstractSubmitterScheduler
implements PrioritySchedulerService {
    protected static final TaskPriority DEFAULT_PRIORITY = TaskPriority.High;
    protected static final int DEFAULT_LOW_PRIORITY_MAX_WAIT_IN_MS = 500;
    protected static final int QUEUE_FRONT_PADDING = 0;
    protected static final int QUEUE_REAR_PADDING = 2;
    protected final TaskPriority defaultPriority;

    protected AbstractPriorityScheduler(TaskPriority defaultPriority) {
        this.defaultPriority = defaultPriority == null ? DEFAULT_PRIORITY : defaultPriority;
    }

    public void setMaxWaitForLowPriority(long maxWaitForLowPriorityInMs) {
        this.getQueueManager().setMaxWaitForLowPriority(maxWaitForLowPriorityInMs);
    }

    @Override
    public long getMaxWaitForLowPriority() {
        return this.getQueueManager().getMaxWaitForLowPriority();
    }

    @Override
    public TaskPriority getDefaultPriority() {
        return this.defaultPriority;
    }

    @Override
    protected final void doSchedule(Runnable task, long delayInMillis) {
        this.doSchedule(task, delayInMillis, this.defaultPriority);
    }

    protected abstract OneTimeTaskWrapper doSchedule(Runnable var1, long var2, TaskPriority var4);

    @Override
    public void execute(Runnable task, TaskPriority priority) {
        this.schedule(task, 0L, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result, TaskPriority priority) {
        return this.submitScheduled(task, result, 0L, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task, TaskPriority priority) {
        return this.submitScheduled(task, 0L, priority);
    }

    @Override
    public void schedule(Runnable task, long delayInMs, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        if (priority == null) {
            priority = this.defaultPriority;
        }
        this.doSchedule(task, delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs, TaskPriority priority) {
        return this.submitScheduled(RunnableCallableAdapter.adapt(task, result), delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        if (priority == null) {
            priority = this.defaultPriority;
        }
        ListenableFutureTask<T> rf = new ListenableFutureTask<T>(task, this);
        this.doSchedule(rf, delayInMs, priority);
        return rf;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.scheduleWithFixedDelay(task, initialDelay, recurringDelay, null);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.scheduleAtFixedRate(task, initialDelay, period, null);
    }

    @Override
    public boolean remove(Runnable task) {
        return this.getQueueManager().remove(task);
    }

    @Override
    public boolean remove(Callable<?> task) {
        return this.getQueueManager().remove(task);
    }

    protected abstract QueueManager getQueueManager();

    @Override
    public int getQueuedTaskCount() {
        int result = 0;
        for (TaskPriority p : TaskPriority.values()) {
            result += this.getQueueManager().getQueueSet(p).queueSize();
        }
        return result;
    }

    @Override
    public int getQueuedTaskCount(TaskPriority priority) {
        if (priority == null) {
            return this.getQueuedTaskCount();
        }
        return this.getQueueManager().getQueueSet(priority).queueSize();
    }

    @Override
    public int getWaitingForExecutionTaskCount() {
        int result = 0;
        for (TaskPriority p : TaskPriority.values()) {
            result += this.getWaitingForExecutionTaskCount(p);
        }
        return result;
    }

    @Override
    public int getWaitingForExecutionTaskCount(TaskPriority priority) {
        if (priority == null) {
            return this.getWaitingForExecutionTaskCount();
        }
        QueueSet qs = this.getQueueManager().getQueueSet(priority);
        int result = qs.executeQueue.size();
        for (int i = 0; i < qs.scheduleQueue.size(); ++i) {
            try {
                if (qs.scheduleQueue.get(i).getScheduleDelay() > 0L) break;
                ++result;
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
        return result;
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }

    protected static interface InternalRunnable
    extends Runnable {
    }

    protected static class GuessRecurringRateTaskWrapper
    extends RecurringTaskWrapper {
        protected final long period;

        public GuessRecurringRateTaskWrapper(Runnable task, QueueSet queueSet, long firstRunTime, long period) {
            super(task, queueSet, firstRunTime);
            this.period = period;
        }

        @Override
        protected void updateNextRunTime() {
            this.nextRunTime += this.period;
        }

        @Override
        public long getScheduleDelay() {
            if (this.executing) {
                return Long.MAX_VALUE;
            }
            return this.nextRunTime - Clock.lastKnownForwardProgressingMillis();
        }
    }

    protected static class AccurateRecurringRateTaskWrapper
    extends RecurringTaskWrapper {
        protected final long period;

        public AccurateRecurringRateTaskWrapper(Runnable task, QueueSet queueSet, long firstRunTime, long period) {
            super(task, queueSet, firstRunTime);
            this.period = period;
        }

        @Override
        protected void updateNextRunTime() {
            this.nextRunTime += this.period;
        }

        @Override
        public long getScheduleDelay() {
            if (this.executing) {
                return Long.MAX_VALUE;
            }
            if (this.nextRunTime > Clock.lastKnownForwardProgressingMillis()) {
                return this.nextRunTime - Clock.accurateForwardProgressingMillis();
            }
            return 0L;
        }
    }

    protected static class GuessRecurringDelayTaskWrapper
    extends RecurringTaskWrapper {
        protected final long recurringDelay;

        public GuessRecurringDelayTaskWrapper(Runnable task, QueueSet queueSet, long firstRunTime, long recurringDelay) {
            super(task, queueSet, firstRunTime);
            this.recurringDelay = recurringDelay;
        }

        @Override
        protected void updateNextRunTime() {
            this.nextRunTime = Clock.accurateForwardProgressingMillis() + this.recurringDelay;
        }

        @Override
        public long getScheduleDelay() {
            if (this.executing) {
                return Long.MAX_VALUE;
            }
            return this.nextRunTime - Clock.lastKnownForwardProgressingMillis();
        }
    }

    protected static class AccurateRecurringDelayTaskWrapper
    extends RecurringTaskWrapper {
        protected final long recurringDelay;

        public AccurateRecurringDelayTaskWrapper(Runnable task, QueueSet queueSet, long firstRunTime, long recurringDelay) {
            super(task, queueSet, firstRunTime);
            this.recurringDelay = recurringDelay;
        }

        @Override
        protected void updateNextRunTime() {
            this.nextRunTime = Clock.accurateForwardProgressingMillis() + this.recurringDelay;
        }

        @Override
        public long getScheduleDelay() {
            if (this.executing) {
                return Long.MAX_VALUE;
            }
            if (this.nextRunTime > Clock.lastKnownForwardProgressingMillis()) {
                return this.nextRunTime - Clock.accurateForwardProgressingMillis();
            }
            return 0L;
        }
    }

    protected static abstract class RecurringTaskWrapper
    extends TaskWrapper {
        protected final QueueSet queueSet;
        protected volatile boolean executing;
        protected long nextRunTime;
        private volatile short executeFlipCounter;

        public RecurringTaskWrapper(Runnable task, QueueSet queueSet, long firstRunTime) {
            super(task);
            this.queueSet = queueSet;
            this.executing = false;
            this.nextRunTime = firstRunTime;
            this.executeFlipCounter = 0;
        }

        @Override
        public long getPureRunTime() {
            return this.nextRunTime;
        }

        @Override
        public long getRunTime() {
            if (this.executing) {
                return Long.MAX_VALUE;
            }
            return this.nextRunTime;
        }

        @Override
        public short getExecuteReference() {
            return this.executeFlipCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canExecute(short executeReference) {
            if (this.executing | this.executeFlipCounter != executeReference) {
                return false;
            }
            Object object = this.queueSet.scheduleQueue.getModificationLock();
            synchronized (object) {
                if (this.executing | this.executeFlipCounter != executeReference) {
                    return false;
                }
                int sourceIndex = this.queueSet.scheduleQueue.indexOf(this);
                if (sourceIndex >= 0) {
                    if (sourceIndex < this.queueSet.scheduleQueue.size() - 1 && this.queueSet.scheduleQueue.get(sourceIndex + 1).getRunTime() != Long.MAX_VALUE) {
                        this.queueSet.scheduleQueue.reposition(sourceIndex, this.queueSet.scheduleQueue.size());
                    }
                    this.executing = true;
                    this.executeFlipCounter = (short)(this.executeFlipCounter + 1);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reschedule() {
            int insertionIndex = -1;
            Object object = this.queueSet.scheduleQueue.getModificationLock();
            synchronized (object) {
                int currentIndex = this.queueSet.scheduleQueue.lastIndexOf(this);
                if (currentIndex > 0) {
                    insertionIndex = SortUtils.getInsertionEndIndex(this.queueSet.scheduleQueueRunTimeByIndex, this.queueSet.scheduleQueue.size() - 1, this.nextRunTime, true);
                    this.queueSet.scheduleQueue.reposition(currentIndex, insertionIndex);
                } else if (currentIndex == 0) {
                    insertionIndex = 0;
                }
                this.executing = false;
                this.executeFlipCounter = (short)(this.executeFlipCounter + 1);
            }
            if (insertionIndex == 0) {
                this.queueSet.queueListener.handleQueueUpdate();
            }
        }

        protected abstract void updateNextRunTime();

        @Override
        public void runTask() {
            if (this.invalidated) {
                return;
            }
            try {
                this.task.run();
            }
            catch (Throwable t) {
                ExceptionUtils.handleException(t);
            }
            if (!this.invalidated) {
                this.updateNextRunTime();
                this.reschedule();
            }
        }
    }

    protected static class ImmediateTaskWrapper
    extends OneTimeTaskWrapper {
        public ImmediateTaskWrapper(Runnable task, Queue<? extends TaskWrapper> taskQueue) {
            super(task, taskQueue, Clock.lastKnownForwardProgressingMillis());
        }

        @Override
        public long getScheduleDelay() {
            return 0L;
        }
    }

    protected static class GuessOneTimeTaskWrapper
    extends OneTimeTaskWrapper {
        public GuessOneTimeTaskWrapper(Runnable task, Queue<? extends TaskWrapper> taskQueue, long runTime) {
            super(task, taskQueue, runTime);
        }

        @Override
        public long getScheduleDelay() {
            return this.runTime - Clock.lastKnownForwardProgressingMillis();
        }
    }

    protected static class AccurateOneTimeTaskWrapper
    extends OneTimeTaskWrapper {
        public AccurateOneTimeTaskWrapper(Runnable task, Queue<? extends TaskWrapper> taskQueue, long runTime) {
            super(task, taskQueue, runTime);
        }

        @Override
        public long getScheduleDelay() {
            if (this.runTime > Clock.lastKnownForwardProgressingMillis()) {
                return this.runTime - Clock.accurateForwardProgressingMillis();
            }
            return 0L;
        }
    }

    protected static abstract class OneTimeTaskWrapper
    extends TaskWrapper {
        protected final Queue<? extends TaskWrapper> taskQueue;
        protected final long runTime;
        protected volatile boolean executed;

        public OneTimeTaskWrapper(Runnable task, Queue<? extends TaskWrapper> taskQueue, long runTime) {
            super(task);
            this.taskQueue = taskQueue;
            this.runTime = runTime;
        }

        @Override
        public long getPureRunTime() {
            return this.runTime;
        }

        @Override
        public long getRunTime() {
            return this.runTime;
        }

        @Override
        public void runTask() {
            if (!this.invalidated) {
                try {
                    this.task.run();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleException(t);
                }
            }
        }

        @Override
        public short getExecuteReference() {
            return 0;
        }

        @Override
        public boolean canExecute(short ignoredExecuteReference) {
            if (!this.executed) {
                this.executed = true;
                if (true & this.taskQueue.remove(this)) {
                    return true;
                }
            }
            return false;
        }
    }

    protected static abstract class TaskWrapper
    implements RunnableContainer {
        protected final Runnable task;
        protected volatile boolean invalidated;

        public TaskWrapper(Runnable task) {
            this.task = task;
            this.invalidated = false;
        }

        public abstract void runTask();

        public void invalidate() {
            this.invalidated = true;
        }

        public abstract short getExecuteReference();

        public abstract boolean canExecute(short var1);

        public abstract long getRunTime();

        public abstract long getPureRunTime();

        public abstract long getScheduleDelay();

        public String toString() {
            return this.task.toString();
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }

    protected static class QueueManager {
        protected final QueueSet highPriorityQueueSet;
        protected final QueueSet lowPriorityQueueSet;
        protected final QueueSet starvablePriorityQueueSet;
        private volatile long maxLowPriorityWaitMillis;

        public QueueManager(QueueSetListener queueSetListener, long maxWaitForLowPriorityInMs) {
            this.highPriorityQueueSet = new QueueSet(queueSetListener);
            this.lowPriorityQueueSet = new QueueSet(queueSetListener);
            this.starvablePriorityQueueSet = new QueueSet(queueSetListener);
            this.setMaxWaitForLowPriority(maxWaitForLowPriorityInMs);
        }

        public QueueSet getQueueSet(TaskPriority priority) {
            if (priority == TaskPriority.High) {
                return this.highPriorityQueueSet;
            }
            if (priority == TaskPriority.Low) {
                return this.lowPriorityQueueSet;
            }
            return this.starvablePriorityQueueSet;
        }

        public List<Runnable> clearQueue() {
            ArrayList<TaskWrapper> wrapperList = new ArrayList<TaskWrapper>(this.highPriorityQueueSet.queueSize() + this.lowPriorityQueueSet.queueSize() + this.starvablePriorityQueueSet.queueSize());
            this.highPriorityQueueSet.drainQueueInto(wrapperList);
            this.lowPriorityQueueSet.drainQueueInto(wrapperList);
            this.starvablePriorityQueueSet.drainQueueInto(wrapperList);
            return ContainerHelper.getContainedRunnables(wrapperList);
        }

        public TaskWrapper getNextTask(boolean allowStarvable) {
            TaskWrapper nextHighTask = this.highPriorityQueueSet.getNextTask();
            TaskWrapper nextLowTask = this.lowPriorityQueueSet.getNextTask();
            TaskWrapper nextTask = nextLowTask == null ? nextHighTask : (nextHighTask == null ? nextLowTask : (nextHighTask.getRunTime() <= nextLowTask.getRunTime() ? nextHighTask : (nextLowTask.getPureRunTime() + this.maxLowPriorityWaitMillis < nextHighTask.getPureRunTime() || nextHighTask.getScheduleDelay() > 0L ? nextLowTask : nextHighTask)));
            if (!allowStarvable) {
                return nextTask;
            }
            if (nextTask == null) {
                return this.starvablePriorityQueueSet.getNextTask();
            }
            if (nextTask.getScheduleDelay() > 0L) {
                TaskWrapper nextStarvableTask = this.starvablePriorityQueueSet.getNextTask();
                if (nextStarvableTask != null && nextStarvableTask.getPureRunTime() < nextTask.getPureRunTime()) {
                    return nextStarvableTask;
                }
                return nextTask;
            }
            return nextTask;
        }

        public boolean remove(Runnable task) {
            return this.highPriorityQueueSet.remove(task) || this.lowPriorityQueueSet.remove(task) || this.starvablePriorityQueueSet.remove(task);
        }

        public boolean remove(Callable<?> task) {
            return this.highPriorityQueueSet.remove(task) || this.lowPriorityQueueSet.remove(task) || this.starvablePriorityQueueSet.remove(task);
        }

        public void setMaxWaitForLowPriority(long maxWaitForLowPriorityInMs) {
            ArgumentVerifier.assertNotNegative(maxWaitForLowPriorityInMs, "maxWaitForLowPriorityInMs");
            this.maxLowPriorityWaitMillis = maxWaitForLowPriorityInMs;
        }

        public long getMaxWaitForLowPriority() {
            return this.maxLowPriorityWaitMillis;
        }
    }

    protected static class QueueSet {
        protected final QueueSetListener queueListener;
        protected final ConcurrentLinkedQueue<OneTimeTaskWrapper> executeQueue;
        protected final ConcurrentArrayList<TaskWrapper> scheduleQueue;
        protected final Function<Integer, Long> scheduleQueueRunTimeByIndex;

        public QueueSet(QueueSetListener queueListener) {
            this.queueListener = queueListener;
            this.executeQueue = new ConcurrentLinkedQueue();
            this.scheduleQueue = new ConcurrentArrayList(0, 2);
            this.scheduleQueueRunTimeByIndex = index -> this.scheduleQueue.get((int)index).getRunTime();
        }

        public void addExecute(OneTimeTaskWrapper task) {
            this.executeQueue.add(task);
            this.queueListener.handleQueueUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addScheduled(TaskWrapper task) {
            int insertionIndex;
            Object object = this.scheduleQueue.getModificationLock();
            synchronized (object) {
                insertionIndex = SortUtils.getInsertionEndIndex(this.scheduleQueueRunTimeByIndex, this.scheduleQueue.size() - 1, task.getRunTime(), true);
                this.scheduleQueue.add(insertionIndex, task);
            }
            if (insertionIndex == 0) {
                this.queueListener.handleQueueUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Callable<?> task) {
            for (TaskWrapper taskWrapper : this.executeQueue) {
                if (!ContainerHelper.isContained(taskWrapper.task, task) || !this.executeQueue.remove(taskWrapper)) continue;
                taskWrapper.invalidate();
                return true;
            }
            Object object = this.scheduleQueue.getModificationLock();
            synchronized (object) {
                Iterator<TaskWrapper> iterator = this.scheduleQueue.iterator();
                while (iterator.hasNext()) {
                    TaskWrapper tw = iterator.next();
                    if (!ContainerHelper.isContained(tw.task, task)) continue;
                    tw.invalidate();
                    iterator.remove();
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Runnable task) {
            for (TaskWrapper taskWrapper : this.executeQueue) {
                if (!ContainerHelper.isContained(taskWrapper.task, task) || !this.executeQueue.remove(taskWrapper)) continue;
                taskWrapper.invalidate();
                return true;
            }
            Object object = this.scheduleQueue.getModificationLock();
            synchronized (object) {
                Iterator<TaskWrapper> iterator = this.scheduleQueue.iterator();
                while (iterator.hasNext()) {
                    TaskWrapper tw = iterator.next();
                    if (!ContainerHelper.isContained(tw.task, task)) continue;
                    tw.invalidate();
                    iterator.remove();
                    return true;
                }
            }
            return false;
        }

        public int queueSize() {
            return this.executeQueue.size() + this.scheduleQueue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drainQueueInto(List<TaskWrapper> removedTasks) {
            QueueSet.clearQueue(this.executeQueue, removedTasks);
            Object object = this.scheduleQueue.getModificationLock();
            synchronized (object) {
                QueueSet.clearQueue(this.scheduleQueue, removedTasks);
            }
        }

        private static void clearQueue(Collection<? extends TaskWrapper> queue, List<TaskWrapper> resultList) {
            boolean resultWasEmpty = resultList.isEmpty();
            for (TaskWrapper taskWrapper : queue) {
                if (taskWrapper.task instanceof Future && ((Future)((Object)taskWrapper.task)).isCancelled()) continue;
                taskWrapper.invalidate();
                if (taskWrapper.task instanceof InternalRunnable) continue;
                if (resultWasEmpty) {
                    resultList.add(taskWrapper);
                    continue;
                }
                resultList.add(SortUtils.getInsertionEndIndex(index -> ((TaskWrapper)resultList.get((int)index)).getRunTime(), resultList.size() - 1, taskWrapper.getRunTime(), true), taskWrapper);
            }
            queue.clear();
        }

        public TaskWrapper getNextTask() {
            TaskWrapper scheduledTask = this.scheduleQueue.peekFirst();
            TaskWrapper executeTask = this.executeQueue.peek();
            if (executeTask != null) {
                if (scheduledTask != null && scheduledTask.getRunTime() < executeTask.getRunTime()) {
                    return scheduledTask;
                }
                return executeTask;
            }
            return scheduledTask;
        }
    }

    protected static interface QueueSetListener {
        public void handleQueueUpdate();
    }
}

