/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.concurrent.Callable;
import org.threadly.concurrent.AbstractSubmitterExecutor;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.util.ArgumentVerifier;

public abstract class AbstractSubmitterScheduler
extends AbstractSubmitterExecutor
implements SubmitterScheduler {
    @Override
    protected void doExecute(Runnable task) {
        this.doSchedule(task, 0L);
    }

    protected abstract void doSchedule(Runnable var1, long var2);

    @Override
    public void schedule(Runnable task, long delayInMs) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        this.doSchedule(task, delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs) {
        return this.submitScheduled(RunnableCallableAdapter.adapt(task, result), delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.doSchedule(lft, delayInMs);
        return lft;
    }
}

