/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.LongAdder;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.concurrent.PriorityScheduler;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.SchedulerService;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.wrapper.limiter.SchedulerServiceLimiter;
import org.threadly.concurrent.wrapper.limiter.SingleThreadSchedulerSubPool;
import org.threadly.concurrent.wrapper.priority.DefaultPriorityWrapper;
import org.threadly.concurrent.wrapper.traceability.ThreadRenamingPriorityScheduler;
import org.threadly.concurrent.wrapper.traceability.ThreadRenamingSchedulerService;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.StringUtils;

public class CentralThreadlyPool {
    protected static final int LOW_PRIORITY_MAX_WAIT_IN_MS = 1000;
    protected static final PoolResizeUpdater POOL_SIZE_UPDATER;
    protected static final PriorityScheduler MASTER_SCHEDULER;
    protected static final PrioritySchedulerService LOW_PRIORITY_MASTER_SCHEDULER;
    protected static final PrioritySchedulerService STARVABLE_PRIORITY_MASTER_SCHEDULER;
    protected static final SchedulerService COMPUTATION_POOL;
    protected static final SchedulerService LOW_PRIORITY_POOL;
    protected static final PrioritySchedulerService SINGLE_THREADED_LOW_PRIORITY_POOL;
    protected static final PerTaskSizingSubmitterScheduler PER_TASK_SIZING_POOL;
    private static volatile int genericThreadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increaseGenericThreads(int count) {
        ArgumentVerifier.assertGreaterThanZero(count, "count");
        Class<CentralThreadlyPool> clazz = CentralThreadlyPool.class;
        synchronized (CentralThreadlyPool.class) {
            POOL_SIZE_UPDATER.adjustPoolSize(count);
            genericThreadCount += count;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static int getGenericThreadCount() {
        return genericThreadCount;
    }

    public static SchedulerService computationPool() {
        return CentralThreadlyPool.computationPool(null);
    }

    public static SchedulerService computationPool(String threadName) {
        if (StringUtils.isNullOrEmpty(threadName)) {
            return COMPUTATION_POOL;
        }
        return new ThreadRenamingSchedulerService(COMPUTATION_POOL, threadName, false);
    }

    public static PrioritySchedulerService lowPrioritySingleThreadPool() {
        return CentralThreadlyPool.lowPrioritySingleThreadPool(null);
    }

    public static PrioritySchedulerService lowPrioritySingleThreadPool(String threadName) {
        if (StringUtils.isNullOrEmpty(threadName)) {
            return SINGLE_THREADED_LOW_PRIORITY_POOL;
        }
        return new ThreadRenamingPriorityScheduler(SINGLE_THREADED_LOW_PRIORITY_POOL, threadName, false);
    }

    public static SchedulerService lowPriorityPool() {
        return CentralThreadlyPool.lowPriorityPool(null);
    }

    public static SchedulerService lowPriorityPool(String threadName) {
        if (StringUtils.isNullOrEmpty(threadName)) {
            return LOW_PRIORITY_POOL;
        }
        return new ThreadRenamingSchedulerService(LOW_PRIORITY_POOL, threadName, false);
    }

    public static PrioritySchedulerService singleThreadPool() {
        return CentralThreadlyPool.singleThreadPool(true, null);
    }

    public static PrioritySchedulerService singleThreadPool(String threadName) {
        return CentralThreadlyPool.singleThreadPool(true, threadName);
    }

    public static PrioritySchedulerService singleThreadPool(boolean threadGuaranteed) {
        return CentralThreadlyPool.singleThreadPool(threadGuaranteed, null);
    }

    public static PrioritySchedulerService singleThreadPool(boolean threadGuaranteed, String threadName) {
        return new SingleThreadSubPool(TaskPriority.High, threadGuaranteed, threadName, false);
    }

    public static PrioritySchedulerService singleThreadPool(boolean threadGuaranteed, String threadName, int threadPriority) {
        return new SinglePriorityThreadSubPool(TaskPriority.High, threadGuaranteed, threadName, false, threadPriority);
    }

    public static SchedulerService threadPool(int threadCount) {
        return CentralThreadlyPool.rangedThreadPool(TaskPriority.High, threadCount, threadCount, null);
    }

    public static SchedulerService threadPool(int threadCount, String threadName) {
        return CentralThreadlyPool.rangedThreadPool(TaskPriority.High, threadCount, threadCount, threadName);
    }

    public static SchedulerService threadPool(TaskPriority priority, int threadCount) {
        return CentralThreadlyPool.rangedThreadPool(priority, threadCount, threadCount, null);
    }

    public static SchedulerService threadPool(TaskPriority priority, int threadCount, String threadName) {
        return CentralThreadlyPool.rangedThreadPool(priority, threadCount, threadCount, threadName);
    }

    public static SchedulerService rangedThreadPool(int guaranteedThreads, int maxThreads) {
        return CentralThreadlyPool.rangedThreadPool(TaskPriority.High, guaranteedThreads, maxThreads, null);
    }

    public static SchedulerService rangedThreadPool(int guaranteedThreads, int maxThreads, String threadName) {
        return CentralThreadlyPool.rangedThreadPool(TaskPriority.High, guaranteedThreads, maxThreads, threadName);
    }

    public static SchedulerService rangedThreadPool(TaskPriority priority, int guaranteedThreads, int maxThreads) {
        return CentralThreadlyPool.rangedThreadPool(priority, guaranteedThreads, maxThreads, null);
    }

    public static SchedulerService rangedThreadPool(TaskPriority priority, int guaranteedThreads, int maxThreads, String threadName) {
        if (maxThreads == 1 && priority == TaskPriority.High) {
            return CentralThreadlyPool.singleThreadPool(guaranteedThreads > 0, threadName);
        }
        if (maxThreads > 0 && Math.max(0, guaranteedThreads) + genericThreadCount >= maxThreads) {
            return new MasterSchedulerResizingLimiter(priority, guaranteedThreads, maxThreads, threadName, false);
        }
        return new DynamicGenericThreadLimiter(priority, guaranteedThreads, maxThreads, threadName, false);
    }

    public static SchedulerService isolatedTaskPool() {
        return CentralThreadlyPool.isolatedTaskPool(null);
    }

    public static SchedulerService isolatedTaskPool(String threadName) {
        if (StringUtils.isNullOrEmpty(threadName)) {
            return PER_TASK_SIZING_POOL;
        }
        return new ThreadRenamingSchedulerService(PER_TASK_SIZING_POOL, threadName, false);
    }

    private static PrioritySchedulerService masterScheduler(TaskPriority defaultPriority, String threadName, boolean replaceName) {
        PrioritySchedulerService result;
        if (defaultPriority == TaskPriority.High) {
            result = MASTER_SCHEDULER;
        } else if (defaultPriority == TaskPriority.Low) {
            result = LOW_PRIORITY_MASTER_SCHEDULER;
        } else if (defaultPriority == TaskPriority.Starvable) {
            result = STARVABLE_PRIORITY_MASTER_SCHEDULER;
        } else {
            throw new IllegalArgumentException("Unknown TaskPriority: " + defaultPriority);
        }
        if (StringUtils.isNullOrEmpty(threadName)) {
            return result;
        }
        return new ThreadRenamingPriorityScheduler(result, threadName, replaceName);
    }

    static {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        genericThreadCount = 1;
        MASTER_SCHEDULER = new PriorityScheduler(cpuCount + genericThreadCount + 1, TaskPriority.High, 1000L, false, new ConfigurableThreadFactory("CentralThreadlyPool-", false, true, 5, null, null, null));
        LOW_PRIORITY_MASTER_SCHEDULER = new DefaultPriorityWrapper(MASTER_SCHEDULER, TaskPriority.Low);
        STARVABLE_PRIORITY_MASTER_SCHEDULER = new DefaultPriorityWrapper(MASTER_SCHEDULER, TaskPriority.Starvable);
        POOL_SIZE_UPDATER = new PoolResizeUpdater(LOW_PRIORITY_MASTER_SCHEDULER);
        COMPUTATION_POOL = new SchedulerServiceLimiter(MASTER_SCHEDULER, cpuCount);
        LOW_PRIORITY_POOL = new DynamicGenericThreadLimiter(TaskPriority.Low, 0, -1, "CentralThreadlyPool-LowPriority", true);
        SINGLE_THREADED_LOW_PRIORITY_POOL = new SinglePriorityThreadSubPool(TaskPriority.Low, false, "CentralThreadlyPool-SingleThreadLowPriority", true, 1);
        PER_TASK_SIZING_POOL = new PerTaskSizingSubmitterScheduler();
    }

    protected static final class PoolResizeUpdater
    extends ReschedulingOperation {
        protected static final int POOL_SIZE_UPDATE_DELAY = 120000;
        protected final LongAdder poolSizeChange = new LongAdder();

        protected PoolResizeUpdater(SubmitterScheduler scheduler) {
            super(scheduler, 120000L);
        }

        public void adjustPoolSize(int delta) {
            if (delta > 0) {
                MASTER_SCHEDULER.adjustPoolSize(delta);
            } else {
                this.poolSizeChange.add(delta);
                this.signalToRun();
            }
        }

        @Override
        protected void run() {
            int adjustment = this.poolSizeChange.intValue();
            if (adjustment != 0) {
                this.poolSizeChange.add(-adjustment);
                MASTER_SCHEDULER.adjustPoolSize(adjustment);
            }
        }
    }

    protected static final class PoolResizer {
        private final int amount;

        public PoolResizer(int amount) {
            this.amount = amount;
            POOL_SIZE_UPDATER.adjustPoolSize(amount);
        }

        protected void finalize() {
            POOL_SIZE_UPDATER.adjustPoolSize(-this.amount);
        }
    }

    protected static class DynamicGenericThreadLimiter
    extends MasterSchedulerResizingLimiter {
        private final int guaranteedThreads;
        private final int maxThreads;

        public DynamicGenericThreadLimiter(TaskPriority priority, int guaranteedThreads, int maxThreads, String threadName, boolean replaceName) {
            super(priority, guaranteedThreads, maxThreads, threadName, replaceName);
            this.guaranteedThreads = guaranteedThreads > 0 ? guaranteedThreads : 0;
            this.maxThreads = this.getMaxConcurrency();
        }

        @Override
        protected boolean taskCapacity() {
            int allowedConcurrency = Math.min(this.maxThreads, this.guaranteedThreads + genericThreadCount);
            if (allowedConcurrency != this.getMaxConcurrency()) {
                this.setMaxConcurrency(allowedConcurrency);
            }
            return super.taskCapacity();
        }
    }

    protected static class MasterSchedulerResizingLimiter
    extends SchedulerServiceLimiter {
        private final Object gcReference;

        public MasterSchedulerResizingLimiter(TaskPriority priority, int guaranteedThreads, int maxThreads, String threadName, boolean replaceName) {
            super(CentralThreadlyPool.masterScheduler(priority, threadName, replaceName), maxThreads < 1 ? Integer.MAX_VALUE : maxThreads);
            if (maxThreads > 0 && guaranteedThreads > maxThreads) {
                throw new IllegalArgumentException("Max threads must be <= guaranteed threads");
            }
            this.gcReference = guaranteedThreads > 0 ? new PoolResizer(guaranteedThreads) : null;
        }
    }

    protected static class SinglePriorityThreadSubPool
    extends SingleThreadSubPool {
        private final int threadPriority;

        protected SinglePriorityThreadSubPool(TaskPriority tickPriority, boolean threadGuaranteed, String threadName, boolean replaceName, int threadPriority) {
            super(tickPriority, threadGuaranteed, threadName, replaceName);
            this.threadPriority = threadPriority;
        }

        @Override
        protected void executeTasks() {
            Thread currentThread = Thread.currentThread();
            int startPriority = currentThread.getPriority();
            if (startPriority == this.threadPriority) {
                super.executeTasks();
            } else {
                currentThread.setPriority(this.threadPriority);
                super.executeTasks();
                currentThread.setPriority(startPriority);
            }
        }
    }

    protected static class SingleThreadSubPool
    extends SingleThreadSchedulerSubPool {
        private final Object gcReference;

        protected SingleThreadSubPool(TaskPriority tickPriority, boolean threadGuaranteed, String threadName, boolean replaceName) {
            super(CentralThreadlyPool.masterScheduler(tickPriority, threadName, replaceName), TaskPriority.High, 1000L);
            this.gcReference = threadGuaranteed ? new PoolResizer(1) : null;
        }

        @Override
        public int getActiveTaskCount() {
            return MASTER_SCHEDULER.getActiveTaskCount();
        }

        @Override
        public int getQueuedTaskCount(TaskPriority priority) {
            return super.getQueuedTaskCount(priority) + MASTER_SCHEDULER.getQueuedTaskCount(priority);
        }

        @Override
        public int getWaitingForExecutionTaskCount(TaskPriority priority) {
            return super.getWaitingForExecutionTaskCount(priority) + MASTER_SCHEDULER.getWaitingForExecutionTaskCount(priority);
        }
    }

    protected static class PerTaskSizingSubmitterScheduler
    extends AbstractSubmitterScheduler
    implements SchedulerService {
        protected PerTaskSizingSubmitterScheduler() {
        }

        @Override
        public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
            ArgumentVerifier.assertNotNull(task, "task");
            MASTER_SCHEDULER.scheduleWithFixedDelay(new PoolResizingOnCollectionTask(task), initialDelay, recurringDelay, TaskPriority.High);
        }

        @Override
        public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
            ArgumentVerifier.assertNotNull(task, "task");
            MASTER_SCHEDULER.scheduleAtFixedRate(new PoolResizingOnCollectionTask(task), initialDelay, period, TaskPriority.High);
        }

        @Override
        protected void doSchedule(Runnable task, long delayInMillis) {
            MASTER_SCHEDULER.doSchedule(new PoolResizingOnCompleteionTask(task), delayInMillis, TaskPriority.High);
        }

        @Override
        public boolean remove(Runnable task) {
            return MASTER_SCHEDULER.remove(task);
        }

        @Override
        public boolean remove(Callable<?> task) {
            return MASTER_SCHEDULER.remove(task);
        }

        @Override
        public int getActiveTaskCount() {
            return MASTER_SCHEDULER.getActiveTaskCount();
        }

        @Override
        public int getQueuedTaskCount() {
            return MASTER_SCHEDULER.getQueuedTaskCount();
        }

        @Override
        public int getWaitingForExecutionTaskCount() {
            return MASTER_SCHEDULER.getWaitingForExecutionTaskCount();
        }

        @Override
        public boolean isShutdown() {
            return MASTER_SCHEDULER.isShutdown();
        }

        protected static class PoolResizingOnCompleteionTask
        implements Runnable,
        RunnableContainer {
            protected final Runnable task;

            public PoolResizingOnCompleteionTask(Runnable task) {
                this.task = task;
                POOL_SIZE_UPDATER.adjustPoolSize(1);
            }

            @Override
            public void run() {
                try {
                    this.task.run();
                }
                finally {
                    POOL_SIZE_UPDATER.adjustPoolSize(-1);
                }
            }

            @Override
            public Runnable getContainedRunnable() {
                return this.task;
            }
        }

        protected static class PoolResizingOnCollectionTask
        implements Runnable,
        RunnableContainer {
            protected final Runnable task;
            private final Object gcReference;

            public PoolResizingOnCollectionTask(Runnable task) {
                this.task = task;
                this.gcReference = new PoolResizer(1);
            }

            @Override
            public void run() {
                this.task.run();
            }

            @Override
            public Runnable getContainedRunnable() {
                return this.task;
            }
        }
    }
}

