/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.util.ExceptionHandler;
import org.threadly.util.ExceptionUtils;

public class ConfigurableThreadFactory
implements ThreadFactory {
    protected static final boolean DEFAULT_NEW_THREADS_DAEMON = false;
    private static final AtomicInteger NEXT_POOL_NUMBER = new AtomicInteger(1);
    protected final ThreadGroup group;
    protected final String threadNamePrefix;
    protected final boolean useDaemonThreads;
    protected final int threadPriority;
    protected final Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    protected final ExceptionHandler defaultThreadlyExceptionHandler;
    protected final Consumer<Thread> notifyThreadCreation;
    private final AtomicInteger nextThreadNumber;

    public static ConfigurableThreadFactoryBuilder builder() {
        return new ConfigurableThreadFactoryBuilder();
    }

    public ConfigurableThreadFactory() {
        this(null, true, false, 5, null, null, null);
    }

    public ConfigurableThreadFactory(String threadNamePrefix, boolean appendPoolIdToPrefix) {
        this(threadNamePrefix, appendPoolIdToPrefix, false, 5, null, null, null);
    }

    public ConfigurableThreadFactory(boolean useDaemonThreads) {
        this(null, true, useDaemonThreads, 5, null, null, null);
    }

    public ConfigurableThreadFactory(int threadPriority) {
        this(null, true, false, threadPriority, null, null, null);
    }

    public ConfigurableThreadFactory(Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler) {
        this(null, true, false, 5, defaultUncaughtExceptionHandler, null, null);
    }

    public ConfigurableThreadFactory(ExceptionHandler defaultThreadlyExceptionHandler) {
        this(null, true, false, 5, null, defaultThreadlyExceptionHandler, null);
    }

    public ConfigurableThreadFactory(Consumer<Thread> notifyThreadCreation) {
        this(null, true, false, 5, null, null, notifyThreadCreation);
    }

    public ConfigurableThreadFactory(String threadNamePrefix, boolean appendPoolIdToPrefix, boolean useDaemonThreads, int threadPriority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, ExceptionHandler defaultThreadlyExceptionHandler, Consumer<Thread> notifyThreadCreation) {
        SecurityManager s;
        if (threadPriority > 10) {
            threadPriority = 10;
        } else if (threadPriority < 1) {
            threadPriority = 1;
        }
        if (threadNamePrefix == null) {
            threadNamePrefix = "pool-";
        }
        if (appendPoolIdToPrefix) {
            threadNamePrefix = (String)threadNamePrefix + NEXT_POOL_NUMBER.getAndIncrement() + "-thread-";
        }
        this.group = (s = System.getSecurityManager()) != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.threadNamePrefix = threadNamePrefix;
        this.useDaemonThreads = useDaemonThreads;
        this.threadPriority = threadPriority;
        this.defaultUncaughtExceptionHandler = uncaughtExceptionHandler;
        this.defaultThreadlyExceptionHandler = defaultThreadlyExceptionHandler;
        this.notifyThreadCreation = notifyThreadCreation;
        this.nextThreadNumber = new AtomicInteger(1);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t;
        if (this.defaultThreadlyExceptionHandler != null) {
            r = new ExceptionHandlerSettingRunnable(this.defaultThreadlyExceptionHandler, r);
        }
        if ((t = new Thread(this.group, r, this.threadNamePrefix + this.nextThreadNumber.getAndIncrement())).isDaemon() != this.useDaemonThreads) {
            t.setDaemon(this.useDaemonThreads);
        }
        if (t.getPriority() != this.threadPriority) {
            t.setPriority(this.threadPriority);
        }
        if (this.defaultUncaughtExceptionHandler != null) {
            t.setUncaughtExceptionHandler(this.defaultUncaughtExceptionHandler);
        }
        if (this.notifyThreadCreation != null) {
            this.notifyThreadCreation.accept(t);
        }
        return t;
    }

    protected static class ExceptionHandlerSettingRunnable
    implements Runnable,
    RunnableContainer {
        private final ExceptionHandler exceptionHandler;
        private final Runnable toRun;

        protected ExceptionHandlerSettingRunnable(ExceptionHandler exceptionHandler, Runnable r) {
            this.exceptionHandler = exceptionHandler;
            this.toRun = r;
        }

        @Override
        public void run() {
            ExceptionUtils.setThreadExceptionHandler(this.exceptionHandler);
            this.toRun.run();
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.toRun;
        }
    }

    public static class ConfigurableThreadFactoryBuilder {
        protected String threadNamePrefix = null;
        protected boolean appendPoolIdToPrefix = true;
        protected boolean useDaemonThreads = false;
        protected int threadPriority = 5;
        protected ExceptionHandler threadlyExceptionHandler = null;
        protected Consumer<Thread> notifyThreadCreation = null;

        public ConfigurableThreadFactoryBuilder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public ConfigurableThreadFactoryBuilder appendPoolIdToPrefix(boolean appendPoolIdToPrefix) {
            this.appendPoolIdToPrefix = appendPoolIdToPrefix;
            return this;
        }

        public ConfigurableThreadFactoryBuilder useDaemonThreads(boolean useDaemonThreads) {
            this.useDaemonThreads = useDaemonThreads;
            return this;
        }

        public ConfigurableThreadFactoryBuilder threadPriority(int threadPriority) {
            this.threadPriority = threadPriority;
            return this;
        }

        public ConfigurableThreadFactoryBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.threadlyExceptionHandler = exceptionHandler;
            return this;
        }

        public ConfigurableThreadFactoryBuilder onThreadCreation(Consumer<Thread> notifyThreadCreation) {
            this.notifyThreadCreation = notifyThreadCreation;
            return this;
        }

        public ConfigurableThreadFactory build() {
            return new ConfigurableThreadFactory(this.threadNamePrefix, this.appendPoolIdToPrefix, this.useDaemonThreads, this.threadPriority, null, this.threadlyExceptionHandler, this.notifyThreadCreation);
        }
    }
}

