/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.threadly.concurrent.CallableContainer;
import org.threadly.concurrent.RunnableContainer;

public final class ContainerHelper {
    public static boolean remove(Collection<? extends RunnableContainer> source, Runnable compareTo) {
        for (RunnableContainer runnableContainer : source) {
            if (!ContainerHelper.isContained(runnableContainer.getContainedRunnable(), compareTo) || !source.remove(runnableContainer)) continue;
            return true;
        }
        return false;
    }

    public static boolean remove(Collection<? extends RunnableContainer> source, Callable<?> compareTo) {
        for (RunnableContainer runnableContainer : source) {
            if (!ContainerHelper.isContained(runnableContainer.getContainedRunnable(), compareTo) || !source.remove(runnableContainer)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContained(Runnable startRunnable, Runnable compareTo) {
        if (startRunnable.equals(compareTo)) {
            return true;
        }
        boolean containedAsRCCI = false;
        if (startRunnable instanceof RunnableContainer) {
            RunnableContainer rci = (RunnableContainer)((Object)startRunnable);
            containedAsRCCI = ContainerHelper.isContained(rci, compareTo);
        }
        if (containedAsRCCI) {
            return true;
        }
        if (startRunnable instanceof CallableContainer) {
            CallableContainer cci = (CallableContainer)((Object)startRunnable);
            return ContainerHelper.isContained(cci, compareTo);
        }
        return false;
    }

    private static boolean isContained(RunnableContainer rci, Runnable compareTo) {
        Runnable containedTask;
        while ((containedTask = rci.getContainedRunnable()) != null) {
            if (containedTask.equals(compareTo)) {
                return true;
            }
            if (containedTask instanceof CallableContainer && ContainerHelper.isContained((CallableContainer)((Object)containedTask), compareTo)) {
                return true;
            }
            if (containedTask instanceof RunnableContainer) {
                rci = (RunnableContainer)((Object)containedTask);
                continue;
            }
            return false;
        }
        return false;
    }

    private static boolean isContained(CallableContainer<?> cci, Runnable compareTo) {
        Callable<?> containedTask;
        while ((containedTask = cci.getContainedCallable()) != null) {
            if (containedTask instanceof RunnableContainer && ContainerHelper.isContained((RunnableContainer)((Object)containedTask), compareTo)) {
                return true;
            }
            if (containedTask instanceof CallableContainer) {
                cci = (CallableContainer)((Object)containedTask);
                continue;
            }
            return false;
        }
        return false;
    }

    public static boolean isContained(Runnable startRunnable, Callable<?> compareTo) {
        boolean isContainedAsCCI = false;
        if (startRunnable instanceof CallableContainer) {
            CallableContainer cci = (CallableContainer)((Object)startRunnable);
            isContainedAsCCI = ContainerHelper.isContained(cci, compareTo);
        }
        if (isContainedAsCCI) {
            return true;
        }
        if (startRunnable instanceof RunnableContainer) {
            RunnableContainer rci = (RunnableContainer)((Object)startRunnable);
            return ContainerHelper.isContained(rci, compareTo);
        }
        return false;
    }

    private static boolean isContained(RunnableContainer rci, Callable<?> compareTo) {
        Runnable containedTask;
        while ((containedTask = rci.getContainedRunnable()) != null) {
            if (containedTask instanceof CallableContainer && ContainerHelper.isContained((CallableContainer)((Object)containedTask), compareTo)) {
                return true;
            }
            if (containedTask instanceof RunnableContainer) {
                rci = (RunnableContainer)((Object)containedTask);
                continue;
            }
            return false;
        }
        return false;
    }

    private static boolean isContained(CallableContainer<?> cci, Callable<?> compareTo) {
        Callable<?> containedTask;
        while ((containedTask = cci.getContainedCallable()) != null) {
            if (containedTask.equals(compareTo)) {
                return true;
            }
            if (containedTask instanceof RunnableContainer && ContainerHelper.isContained((RunnableContainer)((Object)containedTask), compareTo)) {
                return true;
            }
            if (containedTask instanceof CallableContainer) {
                cci = (CallableContainer)((Object)containedTask);
                continue;
            }
            return false;
        }
        return false;
    }

    public static List<Runnable> getContainedRunnables(List<? extends RunnableContainer> sourceList) {
        ArrayList<Runnable> result = new ArrayList<Runnable>(sourceList.size());
        Iterator<? extends RunnableContainer> it = sourceList.iterator();
        while (it.hasNext()) {
            result.add(it.next().getContainedRunnable());
        }
        return result;
    }
}

