/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.threadly.concurrent.DoNothingRunnable;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.FutureCallback;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ImmediateResultListenableFuture;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureAdapterTask;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.future.ListenableRunnableFuture;
import org.threadly.concurrent.future.SettableListenableFuture;
import org.threadly.concurrent.future.watchdog.ConstantTimeWatchdog;
import org.threadly.util.ExceptionHandler;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.Pair;

public class Poller {
    protected final SubmitterScheduler scheduler;
    private final ConstantTimeWatchdog futureWatchdog;
    private final PollRunner runner;

    public Poller(SubmitterScheduler scheduler, long pollFrequency) {
        this(scheduler, pollFrequency, -1L);
    }

    public Poller(SubmitterScheduler scheduler, long pollFrequency, long maxWaitTime) {
        this.scheduler = scheduler;
        this.futureWatchdog = maxWaitTime > 0L && maxWaitTime != Long.MAX_VALUE ? new ConstantTimeWatchdog(scheduler, maxWaitTime, false) : null;
        this.runner = new PollRunner(scheduler, pollFrequency);
    }

    public ListenableFuture<?> watch(Supplier<Boolean> p) {
        ListenableFuture<?> result = this.runner.watch(p);
        if (this.futureWatchdog != null) {
            this.futureWatchdog.watch(result);
        }
        return result;
    }

    public <T> ListenableFuture<T> watch(Future<? extends T> f) {
        if ((this.futureWatchdog == null || f.isDone()) && f instanceof ListenableFuture) {
            return (ListenableFuture)f;
        }
        ListenableFuture<? extends T> result = this.runner.watch(f);
        if (this.futureWatchdog != null) {
            this.futureWatchdog.watch(result);
        }
        return result;
    }

    public <T> ListenableFuture<?> consumeQueue(Queue<? extends T> queue, Consumer<? super T> consumer) {
        return this.consumeQueue(queue, consumer, ExceptionUtils::handleException);
    }

    public <T> ListenableFuture<?> consumeQueue(final Queue<? extends T> queue, final Consumer<? super T> consumer, final ExceptionHandler exceptionHandler) {
        final SettableListenableFuture result = new SettableListenableFuture(false);
        final Supplier<Boolean> readyTest = () -> !queue.isEmpty() || result.isDone();
        this.runner.watch(readyTest).callback(new FutureCallback<Object>(){

            @Override
            public void handleResult(Object ignored) {
                try {
                    ListenableFuture<?> nextReadyLF;
                    do {
                        if (result.isDone()) {
                            return;
                        }
                        Object item = queue.remove();
                        nextReadyLF = Poller.this.runner.watch(readyTest);
                        consumer.accept(item);
                    } while (nextReadyLF.isDone());
                    nextReadyLF.callback(this, Poller.this.scheduler, ListenableFuture.ListenerOptimizationStrategy.InvokingThreadIfDone);
                }
                catch (Throwable t) {
                    this.handleFailure(t);
                }
            }

            @Override
            public void handleFailure(Throwable t) {
                if (exceptionHandler == null) {
                    result.setFailure(t);
                } else {
                    try {
                        exceptionHandler.handleException(t);
                    }
                    finally {
                        Poller.this.runner.watch(readyTest).callback(this, Poller.this.scheduler, ListenableFuture.ListenerOptimizationStrategy.InvokingThreadIfDone);
                    }
                }
            }
        }, this.scheduler);
        return result;
    }

    protected static class PollRunner
    extends ReschedulingOperation {
        private final Collection<Pair<ListenableRunnableFuture<?>, Supplier<Boolean>>> polls = new ConcurrentLinkedQueue();

        public PollRunner(SubmitterScheduler scheduler, long scheduleDelay) {
            super(scheduler, scheduleDelay);
        }

        public ListenableFuture<?> watch(Supplier<Boolean> p) {
            if (p.get().booleanValue()) {
                return ImmediateResultListenableFuture.NULL_RESULT;
            }
            ListenableFutureTask<Object> result = new ListenableFutureTask<Object>(DoNothingRunnable.instance(), null, this.executor);
            this.polls.add(new Pair<ListenableFutureTask<Object>, Supplier<Boolean>>(result, p));
            this.signalToRun();
            return result;
        }

        public <T> ListenableFuture<T> watch(Future<? extends T> f) {
            if (f.isDone()) {
                if (f.isCancelled()) {
                    SettableListenableFuture slf = new SettableListenableFuture();
                    slf.cancel(false);
                    return slf;
                }
                try {
                    return FutureUtils.immediateResultFuture(f.get());
                }
                catch (ExecutionException e) {
                    return FutureUtils.immediateFailureFuture(e.getCause());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            ListenableFutureAdapterTask<? extends T> result = new ListenableFutureAdapterTask<T>(f);
            this.polls.add(new Pair<ListenableFutureAdapterTask<? extends T>, Supplier<Boolean>>(result, f::isDone));
            this.signalToRun();
            return result;
        }

        @Override
        public void run() {
            Iterator<Pair<ListenableRunnableFuture<?>, Supplier<Boolean>>> it = this.polls.iterator();
            boolean hasMore = false;
            while (it.hasNext()) {
                Pair<ListenableRunnableFuture<?>, Supplier<Boolean>> p = it.next();
                if (p.getLeft().isDone()) {
                    it.remove();
                    continue;
                }
                if (p.getRight().get().booleanValue()) {
                    it.remove();
                    p.getLeft().run();
                    continue;
                }
                hasMore = true;
            }
            if (hasMore) {
                this.signalToRun();
            }
        }
    }
}

