/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.concurrent.Callable;
import org.threadly.concurrent.DoNothingRunnable;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.util.ArgumentVerifier;

public class RunnableCallableAdapter<T>
implements Callable<T>,
RunnableContainer {
    protected final Runnable runnable;
    protected final T result;

    public static <T> Callable<T> adapt(Runnable runnable, T result) {
        if (runnable == DoNothingRunnable.instance()) {
            if (result == null) {
                return DoNothingCallable.INSTANCE;
            }
            return () -> result;
        }
        return new RunnableCallableAdapter<T>(runnable, result);
    }

    protected RunnableCallableAdapter(Runnable runnable, T result) {
        ArgumentVerifier.assertNotNull(runnable, "runnable");
        this.runnable = runnable;
        this.result = result;
    }

    @Override
    public Runnable getContainedRunnable() {
        return this.runnable;
    }

    @Override
    public T call() {
        this.runnable.run();
        return this.result;
    }

    protected static final class DoNothingCallable
    implements Callable<Object> {
        protected static final DoNothingCallable INSTANCE = new DoNothingCallable();

        private DoNothingCallable() {
        }

        @Override
        public final Object call() {
            return null;
        }
    }
}

